/*
 * Decompiled with CFR 0.152.
 */
package minicdj.util;

import java.lang.reflect.Array;
import minicdj.util.Collection;
import minicdj.util.Iterator;

public abstract class AbstractCollection
implements Collection {
    protected AbstractCollection() {
    }

    @Override
    public abstract Iterator iterator();

    @Override
    public abstract int size();

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        Iterator itr = c.iterator();
        boolean modified = false;
        int pos = c.size();
        while (--pos >= 0) {
            modified |= this.add(itr.next());
        }
        return modified;
    }

    @Override
    public void clear() {
        Iterator itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            itr.next();
            itr.remove();
        }
    }

    @Override
    public boolean contains(Object o) {
        Iterator itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (!AbstractCollection.equals(o, itr.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator itr = c.iterator();
        int pos = c.size();
        while (--pos >= 0) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean remove(Object o) {
        Iterator itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (!AbstractCollection.equals(o, itr.next())) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.removeAllInternal(c);
    }

    boolean removeAllInternal(Collection c) {
        Iterator itr = this.iterator();
        boolean modified = false;
        int pos = this.size();
        while (--pos >= 0) {
            if (!c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.retainAllInternal(c);
    }

    boolean retainAllInternal(Collection c) {
        Iterator itr = this.iterator();
        boolean modified = false;
        int pos = this.size();
        while (--pos >= 0) {
            if (c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public Object[] toArray() {
        Iterator itr = this.iterator();
        int size = this.size();
        Object[] a = new Object[size];
        int pos = 0;
        while (pos < size) {
            a[pos] = itr.next();
            ++pos;
        }
        return a;
    }

    @Override
    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        } else if (a.length > size) {
            a[size] = null;
        }
        Iterator itr = this.iterator();
        int pos = 0;
        while (pos < size) {
            a[pos] = itr.next();
            ++pos;
        }
        return a;
    }

    public String toString() {
        Iterator itr = this.iterator();
        StringBuffer r = new StringBuffer("[");
        boolean hasNext = itr.hasNext();
        while (hasNext) {
            Object o = itr.next();
            if (o == this) {
                r.append("<this>");
            } else {
                r.append(o);
            }
            hasNext = itr.hasNext();
            if (!hasNext) continue;
            r.append(", ");
        }
        r.append("]");
        return r.toString();
    }

    static final boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static final int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }
}

