/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.PeriodicParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.CyclicSchedule;
import javax.safetycritical.Frame;
import javax.safetycritical.ManagedSchedulableSet;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionMemory;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import vm.RealtimeClock;

@SCJAllowed
public abstract class CyclicExecutive
extends Mission {
    Clock rtClock = Clock.getRealtimeClock();
    AbsoluteTime next = this.rtClock.getTime();
    RelativeTime deltaTime = new RelativeTime(this.rtClock);

    @SCJAllowed
    public CyclicExecutive() {
    }

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    public abstract CyclicSchedule getSchedule(PeriodicEventHandler[] var1);

    @Override
    void runInitialize() {
        this.MSSetForMission = new ManagedSchedulableSet();
        this.initialize();
    }

    @Override
    void runExecute() {
        CyclicSchedule schedule = this.getSchedule((PeriodicEventHandler[])this.MSSetForMission.MSOs);
        Frame[] frames = schedule.getFrames();
        int step = 0;
        while (!this.missionTerminate) {
            PeriodicEventHandler[] handlers = frames[step].handlers;
            int n = handlers.length;
            int handlerIdx = 0;
            while (handlerIdx < n) {
                handlers[handlerIdx].privateMemory.enter(handlers[handlerIdx]);
                ++handlerIdx;
            }
            this.waitForNextFrame(frames[step].duration);
            step = (step + 1) % frames.length;
        }
    }

    @Override
    void runCleanup(MissionMemory mem) {
        this.MSSetForMission.terminateMSOs();
    }

    private void waitForNextFrame(RelativeTime duration) {
        this.next.add(duration, this.next);
        RealtimeClock.delayNativeUntil(this.next);
    }

    private static int find(PeriodicEventHandler[] handlerList, PeriodicEventHandler h) {
        int i = handlerList.length - 1;
        while (i >= 0) {
            if (handlerList[i] == h) {
                return i;
            }
            --i;
        }
        return -1;
    }

    boolean feasible(PeriodicEventHandler[] handlerList, CyclicSchedule schedule) {
        RelativeTime[] nextDeadline = new RelativeTime[handlerList.length];
        int h = 0;
        while (h < handlerList.length) {
            nextDeadline[h] = new RelativeTime(handlerList[h].getReleaseParameter().getDeadline());
            ++h;
        }
        Frame[] frames = schedule.getFrames();
        RelativeTime next = new RelativeTime();
        int step = 0;
        while (step < frames.length) {
            PeriodicEventHandler[] handlers = frames[step].handlers;
            int n = handlers.length;
            RelativeTime startFrame = new RelativeTime(next);
            int handlerIdx = 0;
            while (handlerIdx < n) {
                PeriodicEventHandler hx = handlers[handlerIdx];
                int h2 = CyclicExecutive.find(handlerList, hx);
                if (h2 < 0) {
                    return false;
                }
                next.add(hx.getReleaseParameter().getDeadline());
                if (next.compareTo(nextDeadline[h2]) > 0) {
                    return false;
                }
                nextDeadline[h2].add(((PeriodicParameters)hx.getReleaseParameter()).getPeriod());
                ++handlerIdx;
            }
            if (next.compareTo(startFrame.add(frames[step].duration)) > 0) {
                return false;
            }
            next.add(frames[step].duration);
            ++step;
        }
        int h3 = 0;
        while (h3 < handlerList.length) {
            if (nextDeadline[h3].compareTo(next) <= 0) {
                return false;
            }
            ++h3;
        }
        return true;
    }
}

