/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import icecaptools.IcecapCompileMe;
import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.Monitor;
import javax.realtime.PriorityScheduler;
import javax.realtime.RelativeTime;
import javax.realtime.RtProcess;
import javax.safetycritical.annotate.SCJAllowed;
import vm.ClockInterruptHandler;

@SCJAllowed
public abstract class HighResolutionTime
implements Comparable<HighResolutionTime> {
    Clock clock;
    long millis;
    int nanos;
    static final int NANOS_PER_MILLI = 1000000;

    HighResolutionTime(long millis, int nanos, Clock clock) {
        if (!this.isNormalized(millis, nanos)) {
            this.setNormalized(millis, nanos);
        } else {
            this.millis = millis;
            this.nanos = nanos;
        }
        this.clock = clock;
    }

    private boolean isNormalized(long millis, int nanos) {
        return millis >= 0L && nanos >= 0 && nanos < 1000000 || millis <= 0L && -1000000 < nanos && nanos <= 0;
    }

    public final Clock getClock() {
        return this.clock;
    }

    public final long getMilliseconds() {
        return this.millis;
    }

    public final int getNanoseconds() {
        return this.nanos;
    }

    public void set(HighResolutionTime time) {
        if (time == null) {
            throw new IllegalArgumentException("null parameter");
        }
        if (this.getClass() != time.getClass()) {
            throw new ClassCastException("thrown from HighResolutionTime :: set");
        }
        this.millis = time.millis;
        this.nanos = time.nanos;
        this.clock = time.clock;
    }

    public void set(long millis) {
        this.millis = millis;
        this.nanos = 0;
    }

    public void set(long millis, int nanos) {
        if (!this.isNormalized(millis, nanos)) {
            this.setNormalized(millis, nanos);
        } else {
            this.millis = millis;
            this.nanos = nanos;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.millis ^ this.millis >>> 32);
        result = 31 * result + this.nanos;
        return result;
    }

    public boolean equals(HighResolutionTime time) {
        if (time == null) {
            return false;
        }
        return this.getClass() == time.getClass() && this.millis == time.getMilliseconds() && this.nanos == time.getNanoseconds() && this.clock == time.getClock();
    }

    public boolean equals(Object object) {
        HighResolutionTime time = null;
        if (object instanceof HighResolutionTime) {
            time = (HighResolutionTime)object;
        }
        if (object instanceof AbsoluteTime) {
            time = (AbsoluteTime)object;
        }
        if ((time = object instanceof RelativeTime ? (RelativeTime)object : null) == null || object == null) {
            return false;
        }
        return this.getClass() == time.getClass() && this.millis == time.getMilliseconds() && this.nanos == time.getNanoseconds() && this.clock == time.getClock();
    }

    @Override
    public int compareTo(HighResolutionTime time) {
        if (time == null) {
            throw new IllegalArgumentException("null parameter");
        }
        if (this.getClass() != time.getClass()) {
            throw new ClassCastException("thrown from HighResolutionTime :: compareTo");
        }
        if (this.clock != time.getClock()) {
            throw new IllegalArgumentException("Different clocks");
        }
        if (this.millis < time.getMilliseconds()) {
            return -1;
        }
        if (this.millis > time.getMilliseconds()) {
            return 1;
        }
        if (this.nanos < time.getNanoseconds()) {
            return -1;
        }
        if (this.nanos > time.getNanoseconds()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "(ms,ns) = (" + this.millis + ", " + this.nanos + ")";
    }

    @IcecapCompileMe
    final void setNormalized(long ms, int ns) {
        this.millis = ms + (long)(ns / 1000000);
        this.nanos = ns % 1000000;
        if (this.millis > 0L && this.nanos < 0) {
            if (this.millis == Long.MIN_VALUE) {
                throw new IllegalArgumentException("thrown from HighResolutionTime :: setNormalized");
            }
            --this.millis;
            this.nanos += 1000000;
        } else if (this.millis < 0L && this.nanos > 0) {
            if (this.millis == Long.MAX_VALUE) {
                throw new IllegalArgumentException("thrown from HighResolutionTime :: setNormalized");
            }
            ++this.millis;
            this.nanos -= 1000000;
        }
    }

    public static boolean waitForObject(Object target, HighResolutionTime time) {
        ClockInterruptHandler.instance.disable();
        if (time instanceof RelativeTime && (time.getMilliseconds() < 0L || time.getMilliseconds() == 0L && time.getNanoseconds() < 0)) {
            throw new IllegalArgumentException("relative time is not vaild");
        }
        if (time instanceof RelativeTime && time.getMilliseconds() == 0L && time.getNanoseconds() == 0 || time == null) {
            vm.Monitor.wait(target);
            return false;
        }
        Monitor monitor = Monitor.getMonitor(target);
        monitor.unlockWithOutEnable();
        RtProcess current = PriorityScheduler.instance().current;
        current.isNotified = false;
        current.next_temp = new AbsoluteTime(current.next);
        AbsoluteTime abs = Clock.getRealtimeClock().getTime(current.next);
        if (time instanceof RelativeTime) {
            current.next = abs.add((RelativeTime)time, abs);
        } else if (time instanceof AbsoluteTime) {
            current.next = new AbsoluteTime((AbsoluteTime)time);
        } else {
            throw new UnsupportedOperationException();
        }
        RtProcess nextProcess = PriorityScheduler.instance().pFrame.queue.extractMin();
        nextProcess.state = 2;
        PriorityScheduler.instance().current = nextProcess;
        PriorityScheduler.instance().pFrame.queue.insert(current);
        PriorityScheduler.instance().pFrame.waitQueue.addProcess(monitor, current);
        ClockInterruptHandler.instance.enable();
        ClockInterruptHandler.instance.handle();
        ClockInterruptHandler.instance.disable();
        if (!PriorityScheduler.instance().current.isNotified) {
            PriorityScheduler.instance().current.next_temp = null;
            PriorityScheduler.instance().pFrame.waitQueue.removeProcess(PriorityScheduler.instance().current);
            monitor.lockWithOutEnable();
        }
        ClockInterruptHandler.instance.enable();
        return PriorityScheduler.instance().current.isNotified;
    }
}

