/*
 * Decompiled with CFR 0.152.
 */
package vm;

import devices.Console;
import icecaptools.IcecapCompileMe;
import reflect.ObjectInfo;
import vm.Architecture;
import vm.ClockInterruptHandler;
import vm.ProcessLogic;

public class Process {
    private ProcessLogic logic;
    private int[] stack;
    private ProcessExecutor processExecuter;
    private SP sp;
    private int runtime_data;
    private boolean isFinished;

    public boolean isFinished() {
        return this.isFinished;
    }

    @IcecapCompileMe
    public Process(ProcessLogic logic, int[] stack) {
        this.logic = logic;
        this.stack = stack;
        this.isFinished = false;
        this.processExecuter = new ProcessExecutor(this);
        switch (Architecture.architecture) {
            case 1: {
                this.sp = new X86_64SP();
                break;
            }
            case 2: 
            case 3: {
                this.sp = new X86_32SP();
            }
        }
    }

    @IcecapCompileMe
    public void transferTo(Process nextProcess) {
        Process.transfer(this, nextProcess);
    }

    public final void initialize() {
        Process.executeWithStack(this.processExecuter, this.stack);
    }

    private static native void transfer(Process var0, Process var1);

    private static native void executeWithStack(Runnable var0, int[] var1);

    public int[] getStack() {
        return this.stack;
    }

    public short getJavaStackTop() {
        int top = this.sp.getJSP();
        return this.getIndex(top);
    }

    public int getCStackTop() {
        int top = this.sp.getCSP();
        return this.getIndex(top);
    }

    private short getIndex(int top) {
        return (short)(top - ObjectInfo.getAddress(this.stack) >> 2);
    }

    private static class ProcessExecutor
    implements Runnable {
        private Process thisProcess;
        private boolean isStarted;

        ProcessExecutor(Process thisProcess) {
            this.thisProcess = thisProcess;
        }

        @Override
        @IcecapCompileMe
        public void run() {
            this.isStarted = false;
            this.thisProcess.transferTo(this.thisProcess);
            if (this.isStarted) {
                try {
                    this.thisProcess.logic.run();
                }
                catch (Throwable t) {
                    this.thisProcess.logic.catchError(t);
                }
                ClockInterruptHandler.instance.yield();
                Console.println("Process finished");
                this.thisProcess.isFinished = true;
                while (true) {
                    // Infinite loop
                }
            }
            this.isStarted = true;
        }
    }

    private static abstract class SP {
        private SP() {
        }

        public abstract int getCSP();

        public abstract int getJSP();
    }

    private static class X86_32SP
    extends SP {
        public int csp;
        public int jsp;

        private X86_32SP() {
        }

        @Override
        public int getCSP() {
            return this.csp;
        }

        @Override
        public int getJSP() {
            return this.jsp;
        }
    }

    private static class X86_64SP
    extends SP {
        public long csp;
        public long jsp;

        private X86_64SP() {
        }

        @Override
        public int getCSP() {
            return (int)this.csp;
        }

        @Override
        public int getJSP() {
            return (int)this.jsp;
        }
    }
}

