/*
 * Decompiled with CFR 0.152.
 */
package vm;

import icecaptools.IcecapCompileMe;
import vm.ClockInterruptHandler;
import vm.Scheduler;

public abstract class Monitor {
    protected abstract void lock();

    protected abstract void unlock();

    protected Monitor() {
    }

    public void attach(Object target) {
        this.attachMonitor(target);
        Monitor.lock(this);
        Monitor.unlock(this);
    }

    private native void attachMonitor(Object var1);

    protected static native Object getAttachedMonitor(Object var0);

    @IcecapCompileMe
    private static void lock(Monitor monitor) {
        monitor.lock();
    }

    @IcecapCompileMe
    private static void unlock(Monitor monitor) {
        monitor.unlock();
    }

    @IcecapCompileMe
    public static void wait(Object target) {
        ClockInterruptHandler clock = ClockInterruptHandler.instance;
        clock.disable();
        Scheduler sch = ClockInterruptHandler.getCurrentScheduler();
        sch.wait(target);
        clock.enable();
        ClockInterruptHandler.instance.yield();
    }

    @IcecapCompileMe
    public static void notify(Object target) {
        ClockInterruptHandler clock = ClockInterruptHandler.instance;
        clock.disable();
        Scheduler sch = ClockInterruptHandler.getCurrentScheduler();
        sch.notify(target);
        clock.enable();
    }

    @IcecapCompileMe
    public static void notifyAll(Object target) {
        ClockInterruptHandler clock = ClockInterruptHandler.instance;
        clock.disable();
        Scheduler sch = ClockInterruptHandler.getCurrentScheduler();
        sch.notifyAll(target);
        clock.enable();
    }
}

