/*
 * Decompiled with CFR 0.152.
 */
package vm;

import icecaptools.IcecapCVar;
import icecaptools.IcecapCompileMe;

public class Memory {
    private int base;
    private int size;
    private int free;
    @IcecapCVar
    private static Memory currentMemoryArea;
    @IcecapCVar
    private static Memory heapArea;

    public Memory(int base, int size) {
        this.base = base;
        this.size = size;
        this.free = 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ap: ");
        buffer.append(this.base);
        buffer.append(':');
        buffer.append(this.free);
        buffer.append(':');
        buffer.append(this.size);
        return buffer.toString();
    }

    @IcecapCompileMe
    public void switchToArea(Memory newScope) {
        Memory newScopeArea;
        currentMemoryArea = newScopeArea = newScope;
    }

    @IcecapCompileMe
    public static int allocateBackingStore(int size) {
        if (Memory.heapArea.free + size >= Memory.heapArea.size) {
            throw new OutOfMemoryError();
        }
        int startPtr = Memory.heapArea.base + Memory.heapArea.free;
        Memory.heapArea.free += size;
        return startPtr;
    }

    @IcecapCompileMe
    public static Memory getHeapArea() {
        return heapArea;
    }

    public void reset(int newFree) {
        this.free = newFree;
    }

    public int consumedMemory() {
        return this.free;
    }

    public int getBase() {
        return this.base;
    }

    public int getSize() {
        return this.size;
    }

    public void resize(int newSize) {
        this.size = newSize;
    }
}

