/*
 * Decompiled with CFR 0.152.
 */
package vm;

import gc.BitMap;
import icecaptools.IcecapCVar;
import icecaptools.IcecapCompileMe;
import java.util.Iterator;
import reflect.ClassInfo;
import reflect.ObjectInfo;
import reflect.StaticRefInfo;
import thread.Thread;
import thread.ThreadManager;
import util.ReferenceIterator;
import vm.Heap;

public class HVMHeap
implements Heap {
    @IcecapCVar
    private static int java_heap_size;
    private EmptyIterator emptyIterator = new EmptyIterator();
    private ObjectReferenceIterator objectReferenceIterator;
    private ObjectInfo oi = new ObjectInfo();
    private BitMap bitMap;
    private int blockSize = this._getBlockSize();
    private int startAddress = this._getStartAddress();
    private int heapSize = this._getHeapSize();

    public HVMHeap() {
        this.objectReferenceIterator = new ObjectReferenceIterator(this);
    }

    public static Heap getHeap() {
        return new HVMHeap();
    }

    @Override
    public int getMemoryLeftInProcent() {
        return 100;
    }

    private void unimplemented(String from) {
        Thread.print(from);
        while (true) {
            // Infinite loop
        }
    }

    @Override
    public ReferenceIterator getStaticRef() {
        int[] offsets = StaticRefInfo.getOffsets();
        return new StaticReferenceIterator(offsets);
    }

    @Override
    public ReferenceIterator getRefFromStacks() {
        return new StackRefIterator();
    }

    @Override
    public boolean isRefAnObj(int ref) {
        this.oi.setAddress(ref);
        short classId = this.oi.classId;
        return classId >= 0 && classId < ClassInfo.getNumberOfClasses();
    }

    @Override
    public boolean isRefAllocated(int ref) {
        return true;
    }

    @Override
    public ReferenceIterator getRefFromObj(int ref) {
        ClassInfo cInfo;
        ReferenceIterator referenceOffsets;
        this.oi.setAddress(ref);
        short classId = this.oi.classId;
        if (classId >= 0 && classId < ClassInfo.getNumberOfClasses() && (referenceOffsets = (cInfo = ClassInfo.getClassInfo(classId)).getReferenceOffsets(ref)) != null) {
            this.objectReferenceIterator.initObjectReferenceIterator(referenceOffsets, this.oi);
            return this.objectReferenceIterator;
        }
        return this.emptyIterator;
    }

    private int _getBlockSize() {
        return 4;
    }

    private int _getStartAddress() {
        return HVMHeap.getHeapStart();
    }

    private static native int getHeapStart();

    @IcecapCompileMe
    private int _getHeapSize() {
        return java_heap_size;
    }

    @Override
    public void setBitMap(BitMap bitMap) {
        this.bitMap = bitMap;
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int getStartAddress() {
        return this.startAddress;
    }

    @Override
    public int getHeapSize() {
        return this.heapSize;
    }

    private static class EmptyIterator
    implements ReferenceIterator {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int next() {
            return -1;
        }
    }

    private static class ObjectReferenceIterator
    implements ReferenceIterator {
        private ReferenceIterator referenceOffsets;
        private ObjectInfo oi;
        private int nextRef;
        private int startAddress;
        private int endAddress;

        ObjectReferenceIterator(Heap heap) {
            this.startAddress = heap.getStartAddress();
            this.endAddress = this.startAddress + heap.getHeapSize();
        }

        public void initObjectReferenceIterator(ReferenceIterator referenceOffsets, ObjectInfo oi) {
            this.referenceOffsets = referenceOffsets;
            this.oi = oi;
            this.nextRef = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.nextRef != 0) {
                return true;
            }
            if (this.referenceOffsets.hasNext()) {
                this.nextRef = this.oi.getRef((short)this.referenceOffsets.next());
                if (this.nextRef >= this.startAddress && this.nextRef < this.endAddress) {
                    return true;
                }
                return this.hasNext();
            }
            return false;
        }

        @Override
        public int next() {
            int ref = this.nextRef;
            this.nextRef = 0;
            return ref;
        }
    }

    private static class StackRefIterator
    implements ReferenceIterator {
        private int[] currentStack = null;
        private int currentIndex;
        private short top;
        private Thread currentThread;
        ThreadIterator threads = new ThreadIterator();

        public StackRefIterator() {
            this.advance();
        }

        private void advance() {
            if (this.currentStack == null) {
                if (this.threads.hasNext()) {
                    this.currentThread = this.threads.next();
                    this.currentStack = this.currentThread.getStack();
                    this.currentIndex = 0;
                    this.top = this.currentThread.getJavaStackTop();
                }
            } else {
                ++this.currentIndex;
                if (this.currentIndex == this.top) {
                    this.currentIndex = this.currentThread.getCStackTop();
                } else if (this.currentIndex == this.currentStack.length) {
                    this.currentStack = null;
                    this.advance();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentStack != null;
        }

        @Override
        @IcecapCompileMe
        public int next() {
            int ref = this.currentStack[this.currentIndex];
            this.advance();
            return ref;
        }
    }

    private static class StaticReferenceIterator
    implements ReferenceIterator {
        private int[] offsets;
        private short top;

        public StaticReferenceIterator(int[] offsets) {
            this.offsets = offsets;
            this.top = 0;
        }

        @Override
        public boolean hasNext() {
            return this.top < this.offsets.length;
        }

        @Override
        public int next() {
            int ref = StaticRefInfo.getReference(this.offsets[this.top]);
            this.top = (short)(this.top + 1);
            return ref;
        }
    }

    private static class ThreadIterator
    implements Iterator<Thread> {
        private Iterator<Thread> threads;
        private Thread nextThread;

        public ThreadIterator() {
            ThreadManager manager = Thread.getScheduler();
            this.threads = manager.getThreads();
            this.advance();
        }

        private void advance() {
            if (this.threads.hasNext()) {
                Thread current = this.threads.next();
                if (current != Thread.currentThread()) {
                    this.nextThread = current;
                    if (this.nextThread.getStack() == null) {
                        this.advance();
                    }
                } else {
                    this.advance();
                }
            } else {
                this.nextThread = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextThread != null;
        }

        @Override
        public Thread next() {
            Thread t = this.nextThread;
            this.advance();
            return t;
        }

        @Override
        public void remove() {
        }
    }
}

