/*
 * Decompiled with CFR 0.152.
 */
package vm;

import devices.CR16C.KT4585.CR16CInterruptDispatcher;
import devices.Console;
import devices.i86.I86InterruptDispatcher;
import icecaptools.IcecapCVar;
import icecaptools.IcecapCompileMe;
import vm.Architecture;
import vm.InterruptDispatcher;
import vm.InterruptHandler;
import vm.Monitor;
import vm.Process;
import vm.ProcessLogic;
import vm.Scheduler;

public class ClockInterruptHandler
implements InterruptHandler,
ProcessLogic {
    private Process currentProcess;
    private Scheduler scheduler;
    @IcecapCVar
    private static boolean hvmClockReady;
    private Process handlerProcess;
    public static ClockInterruptHandler instance;
    private static Scheduler currentScheduler;

    @Override
    @IcecapCompileMe
    public void run() {
        while (true) {
            this.currentProcess = this.scheduler.getNextProcess();
            this.enable();
            this.handlerProcess.transferTo(this.currentProcess);
        }
    }

    @Override
    public void catchError(Throwable t) {
        Console.println("Exception thrown from scheduler");
    }

    private ClockInterruptHandler(Scheduler scheduler, int[] stack) {
        this.setScheduler(scheduler);
        this.handlerProcess = new Process(this, stack);
        this.handlerProcess.initialize();
    }

    @Override
    @IcecapCompileMe
    public void handle() {
        this.disable();
        this.currentProcess.transferTo(this.handlerProcess);
    }

    @Override
    @IcecapCompileMe
    public void disable() {
        hvmClockReady = false;
    }

    @Override
    @IcecapCompileMe
    public void enable() {
        hvmClockReady = true;
    }

    @IcecapCompileMe
    public static void initialize(Scheduler scheduler, int[] stack) {
        switch (Architecture.architecture) {
            case 1: 
            case 2: {
                I86InterruptDispatcher.init();
                break;
            }
            case 3: {
                CR16CInterruptDispatcher.init();
            }
        }
        instance = new ClockInterruptHandler(scheduler, stack);
    }

    public void yield() {
        this.handle();
    }

    @Override
    public void register() {
        InterruptDispatcher.registerHandler(this, (byte)0);
    }

    public void startClockHandler(Process process) {
        this.currentProcess = process;
    }

    public void setScheduler(Scheduler sch) {
        this.scheduler = sch;
        if (currentScheduler == sch) {
            Monitor.notify(null);
            Monitor.wait(null);
        }
        currentScheduler = sch;
    }

    public static Scheduler getCurrentScheduler() {
        return currentScheduler;
    }
}

