/*
 * Decompiled with CFR 0.152.
 */
package util;

import icecaptools.IcecapCompileMe;
import util.ReferenceIterator;

public class ReferenceList {
    private int[] refs = new int[2];
    private short top = 0;

    @IcecapCompileMe
    public void add(int ref) {
        if (this.top < this.refs.length) {
            this.refs[this.top] = ref;
            this.top = (short)(this.top + 1);
        } else {
            int[] newRefs = new int[this.refs.length << 1];
            short i = 0;
            while (i < this.top) {
                newRefs[i] = this.refs[i];
                i = (short)(i + 1);
            }
            this.refs = newRefs;
            this.add(ref);
        }
    }

    public void clear() {
        this.top = 0;
    }

    public boolean isEmpty() {
        return this.top == 0;
    }

    public int removeLast() {
        this.top = (short)(this.top - 1);
        return this.refs[this.top];
    }

    public ReferenceIterator iterator() {
        return new ReferenceIteratorImpl(this.refs, this.top);
    }

    public int getLast() {
        return this.refs[this.top - 1];
    }

    private static class ReferenceIteratorImpl
    implements ReferenceIterator {
        private int[] refs;
        private short top;
        private short index;

        ReferenceIteratorImpl(int[] refs, short top) {
            this.refs = refs;
            this.top = top;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.top;
        }

        @Override
        public int next() {
            int n = this.refs[this.index];
            this.index = (short)(this.index + 1);
            return n;
        }
    }
}

