/*
 * Decompiled with CFR 0.152.
 */
package unitTest;

import devices.Console;
import java.util.Enumeration;
import java.util.Vector;
import unitTest.AssertionFailedError;
import unitTest.Protectable;
import unitTest.Test;
import unitTest.TestCase;
import unitTest.TestFailure;

public class TestResult {
    protected Vector<TestFailure> fFailures = new Vector();
    protected Vector<TestFailure> fErrors = new Vector();
    protected Vector<TestFailure> fJMLErrors = new Vector();
    protected int fRunTests = 0;
    private boolean fStop = false;

    public void addError(Test test, Throwable t) {
        this.fErrors.addElement(new TestFailure(test, t));
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.fFailures.add(new TestFailure(test, t));
    }

    public void addJMLError(Test test, Error t) {
        this.fJMLErrors.addElement(new TestFailure(test, t));
    }

    public void endTest(Test test) {
    }

    public int JMLerrorCount() {
        return this.fJMLErrors.size();
    }

    public Enumeration<TestFailure> JMLerrors() {
        return this.fJMLErrors.elements();
    }

    public int failureCount() {
        return this.fFailures.size();
    }

    public Enumeration<TestFailure> failures() {
        return this.fFailures.elements();
    }

    public int errorCount() {
        return this.fErrors.size();
    }

    public Enumeration<TestFailure> errors() {
        return this.fErrors.elements();
    }

    protected void run(final TestCase test) {
        this.startTest(test);
        Protectable p = new Protectable(){

            @Override
            public void protect() throws Throwable {
                test.runBare();
            }
        };
        this.runProtected(test, p);
        this.endTest(test);
    }

    public int runCount() {
        return this.fRunTests;
    }

    public void runProtected(Test test, Protectable p) {
        try {
            p.protect();
        }
        catch (AssertionFailedError e) {
            Console.println("TestResult.runProtected: failure");
            this.addFailure(test, e);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Console.println("TestResult.runProtected: error");
            this.addError(test, e);
        }
    }

    public boolean shouldStop() {
        return this.fStop;
    }

    public void startTest(Test test) {
        int count = test.countTestCases();
        this.fRunTests += count;
    }

    public void stop() {
        this.fStop = true;
    }

    public boolean wasSuccessful() {
        return this.failureCount() == 0 && this.errorCount() == 0 && this.JMLerrorCount() == 0;
    }
}

