/*
 * Decompiled with CFR 0.152.
 */
package thread;

import devices.Console;
import thread.RoundRobinScheduler;
import thread.ThreadManager;
import vm.Process;
import vm.ProcessLogic;

public class Thread
implements Runnable {
    private static final int DEFAULT_THREAD_STACK_SIZE = 1024;
    static final byte FINISHED = 1;
    static final byte RUNNING = 2;
    private static RoundRobinScheduler scheduler;
    Process p;
    byte state;

    public Thread(Runnable logic) {
        this.initialize(logic);
    }

    protected void initialize(final Runnable logic) {
        if (scheduler == null) {
            scheduler = new RoundRobinScheduler();
        }
        this.state = (byte)2;
        this.p = new Process(new ProcessLogic(){

            @Override
            public void run() {
                logic.run();
                Thread.this.state = 1;
            }

            @Override
            public void catchError(Throwable t) {
                Console.println("Thread: exception -> " + t);
            }
        }, new int[1024]);
        this.p.initialize();
    }

    public Thread() {
        this.initialize(this);
    }

    Thread(Process process) {
        this.p = process;
    }

    public void start() {
        scheduler.start();
        scheduler.addThread(this);
    }

    public void join() throws InterruptedException {
        while (this.state == 2) {
        }
    }

    @Override
    public void run() {
    }

    public static ThreadManager getScheduler() {
        return scheduler;
    }

    public static Thread currentThread() {
        return scheduler.currentThread();
    }

    public int[] getStack() {
        return this.p.getStack();
    }

    public short getJavaStackTop() {
        return this.p.getJavaStackTop();
    }

    public int getCStackTop() {
        return this.p.getCStackTop();
    }

    public static void sleep(int ms) throws InterruptedException {
    }

    public static void print(String string) {
        scheduler.disable();
        Console.println(string);
        scheduler.enable();
    }
}

