/*
 * Decompiled with CFR 0.152.
 */
package thread;

import thread.Thread;
import thread.ThreadManager;
import vm.ClockInterruptHandler;
import vm.Process;
import vm.Scheduler;

public class RoundRobinScheduler
extends ThreadManager
implements Scheduler {
    private static final int DEFAULT_SEQUENCER_STACK_SIZE = 1024;
    private boolean started = false;
    private int index = 0;
    private ClockInterruptHandler clockHandler;
    private Thread thr;

    @Override
    public Process getNextProcess() {
        do {
            this.thr = (Thread)this.threads.get(this.index);
            ++this.index;
            if (this.index < this.threads.size()) continue;
            this.index = 0;
        } while (this.thr.state == 1);
        return this.thr.p;
    }

    public void start() {
        if (!this.started) {
            int[] sequencerStack = new int[1024];
            ClockInterruptHandler.initialize(this, sequencerStack);
            this.clockHandler = ClockInterruptHandler.instance;
            Thread mainThread = new Thread(new Process(null, null));
            mainThread.state = (byte)2;
            this.threads.add(mainThread);
            this.clockHandler.register();
            this.clockHandler.startClockHandler(mainThread.p);
            this.started = true;
            this.clockHandler.enable();
            this.clockHandler.yield();
        }
    }

    public void addThread(Thread thread) {
        this.clockHandler.disable();
        this.threads.add(thread);
        this.clockHandler.enable();
    }

    public Thread currentThread() {
        return this.thr;
    }

    public void removeThread(Thread thread) {
        this.clockHandler.disable();
        this.threads.remove(thread);
        this.clockHandler.enable();
    }

    @Override
    public void disable() {
        this.clockHandler.disable();
    }

    @Override
    public void enable() {
        this.clockHandler.enable();
    }

    @Override
    public void wait(Object target) {
    }

    @Override
    public void notify(Object target) {
    }

    @Override
    public void notifyAll(Object target) {
    }
}

