/*
 * Decompiled with CFR 0.152.
 */
package reflect;

import icecaptools.IcecapCVar;
import icecaptools.IcecapCompileMe;
import reflect.CString;
import reflect.ClassInfoX86_32;
import reflect.ClassInfoX86_64;
import reflect.HeapAccessor;
import reflect.ReferencesArray;
import util.ReferenceIterator;
import vm.Address;
import vm.Address32Bit;
import vm.Architecture;
import vm.HardwareObject;

public abstract class ClassInfo
extends HardwareObject {
    @IcecapCVar
    private static short NUMBEROFCLASSES_var;
    @IcecapCVar
    private static byte SUPPORTGC_var;
    private static CachedClassInfo[] clazzes;
    private static ObjectReferenceOffsetIterator iterator;
    private static ReferencesArray ra;
    private static ArrayOverlay ao;
    private static ArrayReferenceOffsetIterator aroi;
    public short superClass;
    public byte dimension;
    public byte hasLock;
    public short dobjectSize;
    public short pobjectSize;

    public ClassInfo(Address address) {
        super(address);
    }

    @IcecapCompileMe
    protected static boolean gCSupported() {
        return SUPPORTGC_var > 0;
    }

    @IcecapCompileMe
    public static ClassInfo getClassInfoFromArchitecture(short index) {
        switch (Architecture.architecture) {
            case 1: {
                return new ClassInfoX86_64(index);
            }
            case 2: {
                return new ClassInfoX86_32(index);
            }
        }
        return null;
    }

    @IcecapCompileMe
    private static CachedClassInfo getCachedClassInfo(short index) {
        if (clazzes != null) {
            CachedClassInfo ccInfo = clazzes[index];
            if (ccInfo != null) {
                return ccInfo;
            }
            ccInfo = new CachedClassInfo();
            ccInfo.cInfo = ClassInfo.getClassInfoFromArchitecture(index);
            ClassInfo.clazzes[index] = ccInfo;
        } else {
            clazzes = new CachedClassInfo[NUMBEROFCLASSES_var];
            iterator = new ObjectReferenceOffsetIterator();
            ra = new ReferencesArray();
            ao = new ArrayOverlay();
            aroi = new ArrayReferenceOffsetIterator();
        }
        return ClassInfo.getCachedClassInfo(index);
    }

    public static ClassInfo getClassInfo(short index) {
        CachedClassInfo ccInfo = ClassInfo.getCachedClassInfo(index);
        return ccInfo.cInfo;
    }

    @IcecapCompileMe
    public static short getNumberOfClasses() {
        return NUMBEROFCLASSES_var;
    }

    public StringBuffer getName() {
        short index = this.getIndex();
        CachedClassInfo ccInfo = clazzes[index];
        StringBuffer buffer = ccInfo.name;
        if (buffer != null) {
            return buffer;
        }
        buffer = new StringBuffer();
        CString cstring = new CString(this.getNameRef());
        while (cstring.hasNext()) {
            buffer.append(cstring.next());
        }
        ccInfo.name = buffer;
        return buffer;
    }

    protected abstract short getIndex();

    protected abstract Address getNameRef();

    public ReferenceIterator getReferenceOffsets(int ref) {
        short index = this.getIndex();
        CachedClassInfo ccInfo = clazzes[index];
        short[] references = ccInfo.references;
        if (references != null) {
            return this.newObjectReferenceOffsetIterator(references);
        }
        if (ClassInfo.gCSupported()) {
            Address r = this.getReferencesRef();
            if (!r.isNull()) {
                return this.getReferenceIterator(ccInfo, r);
            }
            if (this.dimension == 1 && this.dobjectSize > 0) {
                ao.setAddress(ref);
                short length = ClassInfo.ao.length;
                aroi.reset(length);
                return aroi;
            }
        }
        return null;
    }

    private ReferenceIterator getReferenceIterator(CachedClassInfo ccInfo, Address r) {
        ra.setAddress(r);
        int top = 0;
        byte shortReferences = ra.getShortReferences();
        byte byteReferences = ra.getByteReferences();
        short[] references = new short[shortReferences + byteReferences];
        byte i = 0;
        while (i < shortReferences) {
            int n = top;
            top = (byte)(n + 1);
            references[n] = ra.nextShort();
            i = (byte)(i + 1);
        }
        i = 0;
        while (i < byteReferences) {
            short s = ra.nextShort();
            int n = top;
            top = (byte)(n + 1);
            references[n] = (short)(s & 0xFF);
            if ((i = (byte)(i + 1)) < byteReferences) {
                int n2 = top;
                top = (byte)(n2 + 1);
                references[n2] = (short)(s >> 8);
            }
            i = (byte)(i + 1);
        }
        ccInfo.references = references;
        return this.newObjectReferenceOffsetIterator(references);
    }

    protected abstract Address getReferencesRef();

    private ReferenceIterator newObjectReferenceOffsetIterator(short[] offsets) {
        iterator.setOffsets(offsets);
        return iterator;
    }

    public abstract Address getInterfacesRef();

    private static class ArrayOverlay
    extends HeapAccessor {
        public short classid;
        public short length;

        public ArrayOverlay() {
            super(0);
        }

        public void setAddress(int ref) {
            ((Address32Bit)this.address).address = ref;
        }
    }

    private static class ArrayReferenceOffsetIterator
    implements ReferenceIterator {
        private short offset;
        private short length;

        @Override
        public boolean hasNext() {
            return this.length > 0;
        }

        @Override
        public int next() {
            short next = this.offset;
            this.offset = (short)(this.offset + 4);
            this.length = (short)(this.length - 1);
            return next;
        }

        public void reset(short length) {
            this.length = length;
            this.offset = (short)2;
        }
    }

    private static class CachedClassInfo {
        ClassInfo cInfo;
        StringBuffer name;
        short[] references;

        private CachedClassInfo() {
        }
    }

    private static class ObjectReferenceOffsetIterator
    implements ReferenceIterator {
        private short[] offsets;
        private short top;

        @Override
        public boolean hasNext() {
            return this.top < this.offsets.length;
        }

        @Override
        public int next() {
            short ref = this.offsets[this.top];
            this.top = (short)(this.top + 1);
            return ref;
        }

        public void setOffsets(short[] offsets) {
            this.offsets = offsets;
            this.top = 0;
        }
    }
}

