/*
 * Decompiled with CFR 0.152.
 */
package minicdj.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import minicdj.util.AbstractList;
import minicdj.util.Arrays;
import minicdj.util.Collection;
import minicdj.util.Collections;
import minicdj.util.Enumeration;
import minicdj.util.Iterator;
import minicdj.util.List;
import minicdj.util.NoSuchElementException;
import minicdj.util.RandomAccess;

public class Vector
extends AbstractList
implements List,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2767605614048989439L;
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public Vector() {
        this(10, 0);
    }

    public Vector(Collection c) {
        this.elementCount = c.size();
        this.elementData = c.toArray(new Object[this.elementCount]);
    }

    public Vector(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elementData = new Object[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public Vector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public synchronized void copyInto(Object[] a) {
        System.arraycopy(this.elementData, 0, a, 0, this.elementCount);
    }

    public synchronized void trimToSize() {
        Object[] newArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, newArray, 0, this.elementCount);
        this.elementData = newArray;
    }

    public synchronized void ensureCapacity(int minCapacity) {
        if (this.elementData.length >= minCapacity) {
            return;
        }
        int newCapacity = this.capacityIncrement <= 0 ? this.elementData.length * 2 : this.elementData.length + this.capacityIncrement;
        Object[] newArray = new Object[Math.max(newCapacity, minCapacity)];
        System.arraycopy(this.elementData, 0, newArray, 0, this.elementCount);
        this.elementData = newArray;
    }

    public synchronized void setSize(int newSize) {
        ++this.modCount;
        this.ensureCapacity(newSize);
        if (newSize < this.elementCount) {
            Arrays.fill(this.elementData, newSize, this.elementCount, null);
        }
        this.elementCount = newSize;
    }

    public synchronized int capacity() {
        return this.elementData.length;
    }

    @Override
    public synchronized int size() {
        return this.elementCount;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Enumeration elements() {
        return new Enumeration(){
            private int i = 0;

            @Override
            public boolean hasMoreElements() {
                return this.i < Vector.this.elementCount;
            }

            @Override
            public Object nextElement() {
                if (this.i >= Vector.this.elementCount) {
                    throw new NoSuchElementException();
                }
                return Vector.this.elementData[this.i++];
            }
        };
    }

    @Override
    public boolean contains(Object elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    @Override
    public int indexOf(Object elem) {
        return this.indexOf(elem, 0);
    }

    public synchronized int indexOf(Object e, int index) {
        int i = index;
        while (i < this.elementCount) {
            if (Vector.equals(e, this.elementData[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    public synchronized int lastIndexOf(Object e, int index) {
        this.checkBoundExclusive(index);
        int i = index;
        while (i >= 0) {
            if (Vector.equals(e, this.elementData[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public synchronized Object elementAt(int index) {
        this.checkBoundExclusive(index);
        return this.elementData[index];
    }

    public synchronized Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public void setElementAt(Object obj, int index) {
        this.set(index, obj);
    }

    public void removeElementAt(int index) {
        this.remove(index);
    }

    public synchronized void insertElementAt(Object obj, int index) {
        this.checkBoundInclusive(index);
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        ++this.modCount;
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        ++this.elementCount;
        this.elementData[index] = obj;
    }

    public synchronized void addElement(Object obj) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        ++this.modCount;
        this.elementData[this.elementCount++] = obj;
    }

    public synchronized boolean removeElement(Object obj) {
        int idx = this.indexOf(obj, 0);
        if (idx >= 0) {
            this.remove(idx);
            return true;
        }
        return false;
    }

    public synchronized void removeAllElements() {
        if (this.elementCount == 0) {
            return;
        }
        ++this.modCount;
        Arrays.fill(this.elementData, 0, this.elementCount, null);
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            Vector clone = (Vector)super.clone();
            clone.elementData = (Object[])this.elementData.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.toString());
        }
    }

    @Override
    public synchronized Object[] toArray() {
        Object[] newArray = new Object[this.elementCount];
        this.copyInto(newArray);
        return newArray;
    }

    @Override
    public synchronized Object[] toArray(Object[] a) {
        if (a.length < this.elementCount) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.elementCount);
        } else if (a.length > this.elementCount) {
            a[this.elementCount] = null;
        }
        System.arraycopy(this.elementData, 0, a, 0, this.elementCount);
        return a;
    }

    @Override
    public Object get(int index) {
        return this.elementAt(index);
    }

    @Override
    public synchronized Object set(int index, Object element) {
        this.checkBoundExclusive(index);
        Object temp = this.elementData[index];
        this.elementData[index] = element;
        return temp;
    }

    @Override
    public boolean add(Object o) {
        this.addElement(o);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeElement(o);
    }

    @Override
    public void add(int index, Object element) {
        this.insertElementAt(element, index);
    }

    @Override
    public synchronized Object remove(int index) {
        this.checkBoundExclusive(index);
        Object temp = this.elementData[index];
        ++this.modCount;
        --this.elementCount;
        if (index < this.elementCount) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, this.elementCount - index);
        }
        this.elementData[this.elementCount] = null;
        return temp;
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }

    @Override
    public synchronized boolean containsAll(Collection c) {
        return super.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection c) {
        return this.addAll(this.elementCount, c);
    }

    @Override
    public synchronized boolean removeAll(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        int i = 0;
        while (i < this.elementCount) {
            if (c.contains(this.elementData[i])) break;
            ++i;
        }
        if (i == this.elementCount) {
            return false;
        }
        ++this.modCount;
        int j = i++;
        while (i < this.elementCount) {
            if (!c.contains(this.elementData[i])) {
                this.elementData[j++] = this.elementData[i];
            }
            ++i;
        }
        this.elementCount -= i - j;
        return true;
    }

    @Override
    public synchronized boolean retainAll(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        int i = 0;
        while (i < this.elementCount) {
            if (!c.contains(this.elementData[i])) break;
            ++i;
        }
        if (i == this.elementCount) {
            return false;
        }
        ++this.modCount;
        int j = i++;
        while (i < this.elementCount) {
            if (c.contains(this.elementData[i])) {
                this.elementData[j++] = this.elementData[i];
            }
            ++i;
        }
        this.elementCount -= i - j;
        return true;
    }

    @Override
    public synchronized boolean addAll(int index, Collection c) {
        this.checkBoundInclusive(index);
        Iterator itr = c.iterator();
        int csize = c.size();
        ++this.modCount;
        this.ensureCapacity(this.elementCount + csize);
        int end = index + csize;
        if (this.elementCount > 0 && index != this.elementCount) {
            System.arraycopy(this.elementData, index, this.elementData, end, this.elementCount - index);
        }
        this.elementCount += csize;
        while (index < end) {
            this.elementData[index] = itr.next();
            ++index;
        }
        return csize > 0;
    }

    @Override
    public synchronized boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    @Override
    public synchronized String toString() {
        return super.toString();
    }

    @Override
    public synchronized List subList(int fromIndex, int toIndex) {
        List sub = super.subList(fromIndex, toIndex);
        return new Collections.SynchronizedList((Object)this, sub);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        int change = toIndex - fromIndex;
        if (change > 0) {
            ++this.modCount;
            System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, this.elementCount - toIndex);
            int save = this.elementCount;
            this.elementCount -= change;
            Arrays.fill(this.elementData, this.elementCount, save, null);
        } else if (change < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkBoundInclusive(int index) {
        if (index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " > " + this.elementCount);
        }
    }

    private void checkBoundExclusive(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.elementCount);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }
}

