/*
 * Decompiled with CFR 0.152.
 */
package minicdj.util;

import java.io.Serializable;
import minicdj.util.AbstractCollection;
import minicdj.util.AbstractList;
import minicdj.util.AbstractMap;
import minicdj.util.AbstractSet;
import minicdj.util.ArrayList;
import minicdj.util.Arrays;
import minicdj.util.Collection;
import minicdj.util.Comparator;
import minicdj.util.Enumeration;
import minicdj.util.Iterator;
import minicdj.util.List;
import minicdj.util.ListIterator;
import minicdj.util.Map;
import minicdj.util.NoSuchElementException;
import minicdj.util.Random;
import minicdj.util.RandomAccess;
import minicdj.util.Set;
import minicdj.util.SortedMap;
import minicdj.util.SortedSet;

public class Collections {
    private static final int LARGE_LIST_SIZE = 16;
    public static final Set EMPTY_SET = new EmptySet();
    public static final List EMPTY_LIST = new EmptyList();
    public static final Map EMPTY_MAP = new EmptyMap();
    private static final ReverseComparator rcInstance = new ReverseComparator();
    private static Random defaultRandom = null;

    private static boolean isSequential(List l) {
        return !(l instanceof RandomAccess) && l.size() > 16;
    }

    private Collections() {
    }

    public static void copy(List dest, List source) {
        int pos = source.size();
        if (dest.size() < pos) {
            throw new IndexOutOfBoundsException("Source does not fit in dest");
        }
        Iterator i1 = source.iterator();
        ListIterator i2 = dest.listIterator();
        while (--pos >= 0) {
            i2.next();
            i2.set(i1.next());
        }
    }

    public static Enumeration enumeration(Collection c) {
        final Iterator i = c.iterator();
        return new Enumeration(){

            @Override
            public final boolean hasMoreElements() {
                return i.hasNext();
            }

            @Override
            public final Object nextElement() {
                return i.next();
            }
        };
    }

    public static void fill(List l, Object val) {
        ListIterator itr = l.listIterator();
        int i = l.size() - 1;
        while (i >= 0) {
            itr.next();
            itr.set(val);
            --i;
        }
    }

    public static int indexOfSubList(List source, List target) {
        int ssize = source.size();
        int i = 0;
        int j = target.size();
        while (j <= ssize) {
            if (source.subList(i, j).equals(target)) {
                return i;
            }
            ++i;
            ++j;
        }
        return -1;
    }

    public static int lastIndexOfSubList(List source, List target) {
        int ssize = source.size();
        int i = ssize - target.size();
        int j = ssize;
        while (i >= 0) {
            if (source.subList(i, j).equals(target)) {
                return i;
            }
            --i;
            --j;
        }
        return -1;
    }

    public static ArrayList list(Enumeration e) {
        ArrayList l = new ArrayList();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        return l;
    }

    public static List nCopies(int n, Object o) {
        return new CopiesList(n, o);
    }

    public static boolean replaceAll(List list, Object oldval, Object newval) {
        ListIterator itr = list.listIterator();
        boolean replace_occured = false;
        int i = list.size();
        while (--i >= 0) {
            if (!AbstractCollection.equals(oldval, itr.next())) continue;
            itr.set(newval);
            replace_occured = true;
        }
        return replace_occured;
    }

    public static void reverse(List l) {
        ListIterator i1 = l.listIterator();
        int pos1 = 1;
        int pos2 = l.size();
        ListIterator i2 = l.listIterator(pos2);
        while (pos1 < pos2) {
            Object o = i1.next();
            i1.set(i2.previous());
            i2.set(o);
            ++pos1;
            --pos2;
        }
    }

    public static Comparator reverseOrder() {
        return rcInstance;
    }

    public static void rotate(List list, int distance) {
        int size = list.size();
        if (size == 0) {
            return;
        }
        if ((distance %= size) == 0) {
            return;
        }
        if (distance < 0) {
            distance += size;
        }
        if (Collections.isSequential(list)) {
            Collections.reverse(list);
            Collections.reverse(list.subList(0, distance));
            Collections.reverse(list.subList(distance, size));
        } else {
            int a = size;
            int lcm = distance;
            int b = a % lcm;
            while (b != 0) {
                a = lcm;
                lcm = b;
                b = a % lcm;
            }
            while (--lcm >= 0) {
                Object o = list.get(lcm);
                int i = lcm + distance;
                while (i != lcm) {
                    o = list.set(i, o);
                    i = (i + distance) % size;
                }
                list.set(lcm, o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void shuffle(List l) {
        if (defaultRandom == null) {
            Class<Collections> clazz = Collections.class;
            // MONITORENTER : minicdj.util.Collections.class
            if (defaultRandom == null) {
                defaultRandom = new Random();
            }
            // MONITOREXIT : clazz
        }
        Collections.shuffle(l, defaultRandom);
    }

    public static void shuffle(List l, Random r) {
        int lsize = l.size();
        ListIterator i = l.listIterator(lsize);
        boolean sequential = Collections.isSequential(l);
        Object[] a = null;
        if (sequential) {
            a = l.toArray();
        }
        int pos = lsize - 1;
        while (pos > 0) {
            Object o;
            int swap = r.nextInt(pos + 1);
            if (sequential) {
                o = a[swap];
                a[swap] = i.previous();
            } else {
                o = l.set(swap, i.previous());
            }
            i.set(o);
            --pos;
        }
    }

    public static Set singleton(Object o) {
        return new SingletonSet(o);
    }

    public static List singletonList(Object o) {
        return new SingletonList(o);
    }

    public static Map singletonMap(Object key, Object value) {
        return new SingletonMap(key, value);
    }

    public static void swap(List l, int i, int j) {
        l.set(i, l.set(j, l.get(i)));
    }

    public static Collection synchronizedCollection(Collection c) {
        return new SynchronizedCollection(c);
    }

    public static List synchronizedList(List l) {
        if (l instanceof RandomAccess) {
            return new SynchronizedRandomAccessList(l);
        }
        return new SynchronizedList(l);
    }

    public static Map synchronizedMap(Map m) {
        return new SynchronizedMap(m);
    }

    public static Set synchronizedSet(Set s) {
        return new SynchronizedSet(s);
    }

    public static SortedMap synchronizedSortedMap(SortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static SortedSet synchronizedSortedSet(SortedSet s) {
        return new SynchronizedSortedSet(s);
    }

    public static Collection unmodifiableCollection(Collection c) {
        return new UnmodifiableCollection(c);
    }

    public static List unmodifiableList(List l) {
        if (l instanceof RandomAccess) {
            return new UnmodifiableRandomAccessList(l);
        }
        return new UnmodifiableList(l);
    }

    public static Map unmodifiableMap(Map m) {
        return new UnmodifiableMap(m);
    }

    public static Set unmodifiableSet(Set s) {
        return new UnmodifiableSet(s);
    }

    public static SortedMap unmodifiableSortedMap(SortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet s) {
        return new UnmodifiableSortedSet(s);
    }

    private static final class CopiesList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 2739099268398711800L;
        private final int n;
        private final Object element;

        CopiesList(int n, Object o) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.n = n;
            this.element = o;
        }

        @Override
        public int size() {
            return this.n;
        }

        @Override
        public Object get(int index) {
            if (index < 0 || index >= this.n) {
                throw new IndexOutOfBoundsException();
            }
            return this.element;
        }

        @Override
        public boolean contains(Object o) {
            return this.n > 0 && CopiesList.equals(o, this.element);
        }

        @Override
        public int indexOf(Object o) {
            return this.n > 0 && CopiesList.equals(o, this.element) ? 0 : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return CopiesList.equals(o, this.element) ? this.n - 1 : -1;
        }

        @Override
        public List subList(int from, int to) {
            if (from < 0 || to > this.n) {
                throw new IndexOutOfBoundsException();
            }
            return new CopiesList(to - from, this.element);
        }

        @Override
        public Object[] toArray() {
            Object[] a = new Object[this.n];
            Arrays.fill(a, this.element);
            return a;
        }

        @Override
        public String toString() {
            StringBuffer r = new StringBuffer("{");
            int i = this.n - 1;
            while (--i > 0) {
                r.append(this.element).append(", ");
            }
            r.append(this.element).append("}");
            return r.toString();
        }
    }

    private static final class EmptyList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 8842843931221139166L;

        EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Object get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection c) {
            return c.isEmpty();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof List && ((List)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public int indexOf(Object o) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return -1;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean removeAll(Collection c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection c) {
            return false;
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public String toString() {
            return "[]";
        }
    }

    private static final class EmptyMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        EmptyMap() {
        }

        @Override
        public Set entrySet() {
            return EMPTY_SET;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).isEmpty();
        }

        @Override
        public Object get(Object o) {
            return null;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public Set keySet() {
            return EMPTY_SET;
        }

        @Override
        public Object remove(Object o) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Collection values() {
            return EMPTY_SET;
        }

        @Override
        public String toString() {
            return "[]";
        }
    }

    private static final class EmptySet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        EmptySet() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator iterator() {
            return EMPTY_LIST.iterator();
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection c) {
            return c.isEmpty();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Set && ((Set)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean removeAll(Collection c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection c) {
            return false;
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public String toString() {
            return "[]";
        }
    }

    private static final class ReverseComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;

        ReverseComparator() {
        }
    }

    private static final class SingletonList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 3093736618740652951L;
        private final Object element;

        SingletonList(Object o) {
            this.element = o;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Object get(int index) {
            if (index == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean contains(Object o) {
            return SingletonList.equals(o, this.element);
        }

        @Override
        public boolean containsAll(Collection c) {
            Iterator i = c.iterator();
            int pos = c.size();
            while (--pos >= 0) {
                if (SingletonList.equals(i.next(), this.element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return 31 + SingletonList.hashCode(this.element);
        }

        @Override
        public int indexOf(Object o) {
            return SingletonList.equals(o, this.element) ? 0 : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return SingletonList.equals(o, this.element) ? 0 : -1;
        }

        @Override
        public List subList(int from, int to) {
            if (from == to && (to == 0 || to == 1)) {
                return EMPTY_LIST;
            }
            if (from == 0 && to == 1) {
                return this;
            }
            if (from > to) {
                throw new IllegalArgumentException();
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.element};
        }

        @Override
        public String toString() {
            return "[" + this.element + "]";
        }
    }

    private static final class SingletonMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        private final Object k;
        private final Object v;
        private transient Set entries;

        SingletonMap(Object key, Object value) {
            this.k = key;
            this.v = value;
        }

        @Override
        public Set entrySet() {
            if (this.entries == null) {
                this.entries = Collections.singleton(new AbstractMap.BasicMapEntry(this.k, this.v){

                    @Override
                    public Object setValue(Object o) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
            return this.entries;
        }

        @Override
        public boolean containsKey(Object key) {
            return SingletonMap.equals(key, this.k);
        }

        @Override
        public boolean containsValue(Object value) {
            return SingletonMap.equals(value, this.v);
        }

        @Override
        public Object get(Object key) {
            return SingletonMap.equals(key, this.k) ? this.v : null;
        }

        @Override
        public int hashCode() {
            return SingletonMap.hashCode(this.k) ^ SingletonMap.hashCode(this.v);
        }

        @Override
        public Set keySet() {
            if (this.keys == null) {
                this.keys = Collections.singleton(this.k);
            }
            return this.keys;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Collection values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }

        @Override
        public String toString() {
            return "{" + this.k + "=" + this.v + "}";
        }
    }

    private static final class SingletonSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        final Object element;

        SingletonSet(Object o) {
            this.element = o;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                private boolean hasNext = true;

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public Object next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return SingletonSet.this.element;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return SingletonSet.equals(o, this.element);
        }

        @Override
        public boolean containsAll(Collection c) {
            Iterator i = c.iterator();
            int pos = c.size();
            while (--pos >= 0) {
                if (SingletonSet.equals(i.next(), this.element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return SingletonSet.hashCode(this.element);
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.element};
        }

        @Override
        public String toString() {
            return "[" + this.element + "]";
        }
    }

    static class SynchronizedCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection c;
        final Object mutex;

        SynchronizedCollection(Collection c) {
            this.c = c;
            this.mutex = this;
            if (c == null) {
                throw new NullPointerException();
            }
        }

        SynchronizedCollection(Object sync, Collection c) {
            this.c = c;
            this.mutex = sync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.add(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection col) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(col);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection c1) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(c1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator iterator() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedIterator(this.mutex, this.c.iterator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection col) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(col);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection col) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(col);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray(Object[] a) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }
    }

    private static class SynchronizedIterator
    implements Iterator {
        final Object mutex;
        private final Iterator i;

        SynchronizedIterator(Object sync, Iterator i) {
            this.i = i;
            this.mutex = sync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object next() {
            Object object = this.mutex;
            synchronized (object) {
                return this.i.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = this.mutex;
            synchronized (object) {
                return this.i.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Object object = this.mutex;
            synchronized (object) {
                this.i.remove();
            }
        }
    }

    static class SynchronizedList
    extends SynchronizedCollection
    implements List {
        private static final long serialVersionUID = -7754090372962971524L;
        final List list;

        SynchronizedList(List l) {
            super(l);
            this.list = l;
        }

        SynchronizedList(Object sync, List l) {
            super(sync, l);
            this.list = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, Object o) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.add(index, o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.get(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.lastIndexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator listIterator() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedListIterator(this.mutex, this.list.listIterator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator listIterator(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedListIterator(this.mutex, this.list.listIterator(index));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object remove(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object set(int index, Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.set(index, o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList(this.mutex, this.list.subList(fromIndex, toIndex));
            }
        }
    }

    private static final class SynchronizedListIterator
    extends SynchronizedIterator
    implements ListIterator {
        private final ListIterator li;

        SynchronizedListIterator(Object sync, ListIterator li) {
            super(sync, li);
            this.li = li;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                this.li.add(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasPrevious() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.hasPrevious();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int nextIndex() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.nextIndex();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object previous() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.previous();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int previousIndex() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.previousIndex();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                this.li.set(o);
            }
        }
    }

    private static class SynchronizedMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map m;
        final Object mutex;
        private transient Set entries;
        private transient Set keys;
        private transient Collection values;

        SynchronizedMap(Map m) {
            this.m = m;
            this.mutex = this;
            if (m == null) {
                throw new NullPointerException();
            }
        }

        SynchronizedMap(Object sync, Map m) {
            this.m = m;
            this.mutex = sync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.m.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set entrySet() {
            if (this.entries == null) {
                Object object = this.mutex;
                synchronized (object) {
                    this.entries = new SynchronizedSet(this.mutex, this.m.entrySet()){
                        private static final long serialVersionUID = 1L;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Iterator iterator() {
                            Object object = this.mutex;
                            synchronized (object) {
                                return new SynchronizedIterator(this.mutex, this.c.iterator()){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public Object next() {
                                        Object object = this.mutex;
                                        synchronized (object) {
                                            class SynchronizedMapEntry
                                            implements Map.Entry {
                                                final Map.Entry e;

                                                SynchronizedMapEntry(Object o) {
                                                    this.e = (Map.Entry)o;
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public boolean equals(Object o) {
                                                    Object object = SynchronizedMap.this.mutex;
                                                    synchronized (object) {
                                                        return this.e.equals(o);
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public Object getKey() {
                                                    Object object = SynchronizedMap.this.mutex;
                                                    synchronized (object) {
                                                        return this.e.getKey();
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public Object getValue() {
                                                    Object object = SynchronizedMap.this.mutex;
                                                    synchronized (object) {
                                                        return this.e.getValue();
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public int hashCode() {
                                                    Object object = SynchronizedMap.this.mutex;
                                                    synchronized (object) {
                                                        return this.e.hashCode();
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public Object setValue(Object value) {
                                                    Object object = SynchronizedMap.this.mutex;
                                                    synchronized (object) {
                                                        return this.e.setValue(value);
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public String toString() {
                                                    Object object = SynchronizedMap.this.mutex;
                                                    synchronized (object) {
                                                        return this.e.toString();
                                                    }
                                                }
                                            }
                                            return new SynchronizedMapEntry(super.next());
                                        }
                                    }
                                };
                            }
                        }
                    };
                }
            }
            return this.entries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set keySet() {
            if (this.keys == null) {
                Object object = this.mutex;
                synchronized (object) {
                    this.keys = new SynchronizedSet(this.mutex, this.m.keySet());
                }
            }
            return this.keys;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object put(Object key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map map) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection values() {
            if (this.values == null) {
                Object object = this.mutex;
                synchronized (object) {
                    this.values = new SynchronizedCollection(this.mutex, this.m.values());
                }
            }
            return this.values;
        }
    }

    private static final class SynchronizedRandomAccessList
    extends SynchronizedList
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List l) {
            super(l);
        }

        SynchronizedRandomAccessList(Object sync, List l) {
            super(sync, l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.mutex, this.list.subList(fromIndex, toIndex));
            }
        }
    }

    static class SynchronizedSet
    extends SynchronizedCollection
    implements Set {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set s) {
            super(s);
        }

        SynchronizedSet(Object sync, Set s) {
            super(sync, s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.hashCode();
            }
        }
    }

    private static final class SynchronizedSortedMap
    extends SynchronizedMap
    implements SortedMap {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap sm;

        SynchronizedSortedMap(SortedMap sm) {
            super(sm);
            this.sm = sm;
        }

        SynchronizedSortedMap(Object sync, SortedMap sm) {
            super(sync, sm);
            this.sm = sm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap headMap(Object toKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap(this.mutex, this.sm.headMap(toKey));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.lastKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap subMap(Object fromKey, Object toKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap(this.mutex, this.sm.subMap(fromKey, toKey));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap tailMap(Object fromKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap(this.mutex, this.sm.tailMap(fromKey));
            }
        }
    }

    private static final class SynchronizedSortedSet
    extends SynchronizedSet
    implements SortedSet {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet ss;

        SynchronizedSortedSet(SortedSet ss) {
            super(ss);
            this.ss = ss;
        }

        SynchronizedSortedSet(Object sync, SortedSet ss) {
            super(sync, ss);
            this.ss = ss;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet headSet(Object toElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet(this.mutex, this.ss.headSet(toElement));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.last();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet subSet(Object fromElement, Object toElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet(this.mutex, this.ss.subSet(fromElement, toElement));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet tailSet(Object fromElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet(this.mutex, this.ss.tailSet(fromElement));
            }
        }
    }

    private static class UnmodifiableCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection c;

        UnmodifiableCollection(Collection c) {
            this.c = c;
            if (c == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        @Override
        public boolean containsAll(Collection c1) {
            return this.c.containsAll(c1);
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new UnmodifiableIterator(this.c.iterator());
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.c.toArray(a);
        }

        public String toString() {
            return this.c.toString();
        }
    }

    private static class UnmodifiableIterator
    implements Iterator {
        private final Iterator i;

        UnmodifiableIterator(Iterator i) {
            this.i = i;
        }

        @Override
        public Object next() {
            return this.i.next();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableList
    extends UnmodifiableCollection
    implements List {
        private static final long serialVersionUID = -283967356065247728L;
        final List list;

        UnmodifiableList(List l) {
            super(l);
            this.list = l;
        }

        @Override
        public void add(int index, Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            return this.list.equals(o);
        }

        @Override
        public Object get(int index) {
            return this.list.get(index);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return new UnmodifiableListIterator(this.list.listIterator());
        }

        @Override
        public ListIterator listIterator(int index) {
            return new UnmodifiableListIterator(this.list.listIterator(index));
        }

        @Override
        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object set(int index, Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return Collections.unmodifiableList(this.list.subList(fromIndex, toIndex));
        }
    }

    private static final class UnmodifiableListIterator
    extends UnmodifiableIterator
    implements ListIterator {
        private final ListIterator li;

        UnmodifiableListIterator(ListIterator li) {
            super(li);
            this.li = li;
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            return this.li.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.li.nextIndex();
        }

        @Override
        public Object previous() {
            return this.li.previous();
        }

        @Override
        public int previousIndex() {
            return this.li.previousIndex();
        }

        @Override
        public void set(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map m;
        private transient Set entries;
        private transient Set keys;
        private transient Collection values;

        UnmodifiableMap(Map m) {
            this.m = m;
            if (m == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.m.containsValue(value);
        }

        @Override
        public Set entrySet() {
            if (this.entries == null) {
                this.entries = new UnmodifiableEntrySet(this.m.entrySet());
            }
            return this.entries;
        }

        @Override
        public boolean equals(Object o) {
            return this.m.equals(o);
        }

        @Override
        public Object get(Object key) {
            return this.m.get(key);
        }

        @Override
        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public Set keySet() {
            if (this.keys == null) {
                this.keys = new UnmodifiableSet(this.m.keySet());
            }
            return this.keys;
        }

        @Override
        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        public String toString() {
            return this.m.toString();
        }

        @Override
        public Collection values() {
            if (this.values == null) {
                this.values = new UnmodifiableCollection(this.m.values());
            }
            return this.values;
        }

        private static final class UnmodifiableEntrySet
        extends UnmodifiableSet
        implements Serializable {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set s) {
                super(s);
            }

            @Override
            public Iterator iterator() {
                return new UnmodifiableIterator(this.c.iterator()){

                    @Override
                    public Object next() {
                        final Map.Entry e = (Map.Entry)super.next();
                        return new Map.Entry(){

                            @Override
                            public boolean equals(Object o) {
                                return e.equals(o);
                            }

                            @Override
                            public Object getKey() {
                                return e.getKey();
                            }

                            @Override
                            public Object getValue() {
                                return e.getValue();
                            }

                            @Override
                            public int hashCode() {
                                return e.hashCode();
                            }

                            @Override
                            public Object setValue(Object value) {
                                throw new UnsupportedOperationException();
                            }

                            public String toString() {
                                return e.toString();
                            }
                        };
                    }
                };
            }
        }
    }

    private static final class UnmodifiableRandomAccessList
    extends UnmodifiableList
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List l) {
            super(l);
        }
    }

    private static class UnmodifiableSet
    extends UnmodifiableCollection
    implements Set {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set s) {
            super(s);
        }

        @Override
        public boolean equals(Object o) {
            return this.c.equals(o);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    private static class UnmodifiableSortedMap
    extends UnmodifiableMap
    implements SortedMap {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap sm;

        UnmodifiableSortedMap(SortedMap sm) {
            super(sm);
            this.sm = sm;
        }

        @Override
        public Comparator comparator() {
            return this.sm.comparator();
        }

        @Override
        public Object firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public SortedMap headMap(Object toKey) {
            return new UnmodifiableSortedMap(this.sm.headMap(toKey));
        }

        @Override
        public Object lastKey() {
            return this.sm.lastKey();
        }

        @Override
        public SortedMap subMap(Object fromKey, Object toKey) {
            return new UnmodifiableSortedMap(this.sm.subMap(fromKey, toKey));
        }

        @Override
        public SortedMap tailMap(Object fromKey) {
            return new UnmodifiableSortedMap(this.sm.tailMap(fromKey));
        }
    }

    private static class UnmodifiableSortedSet
    extends UnmodifiableSet
    implements SortedSet {
        private static final long serialVersionUID = -4929149591599911165L;
        private SortedSet ss;

        UnmodifiableSortedSet(SortedSet ss) {
            super(ss);
            this.ss = ss;
        }

        @Override
        public Comparator comparator() {
            return this.ss.comparator();
        }

        @Override
        public Object first() {
            return this.ss.first();
        }

        @Override
        public SortedSet headSet(Object toElement) {
            return new UnmodifiableSortedSet(this.ss.headSet(toElement));
        }

        @Override
        public Object last() {
            return this.ss.last();
        }

        @Override
        public SortedSet subSet(Object fromElement, Object toElement) {
            return new UnmodifiableSortedSet(this.ss.subSet(fromElement, toElement));
        }

        @Override
        public SortedSet tailSet(Object fromElement) {
            return new UnmodifiableSortedSet(this.ss.tailSet(fromElement));
        }
    }
}

