/*
 * Decompiled with CFR 0.152.
 */
package minicdj.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import minicdj.util.AbstractCollection;
import minicdj.util.AbstractList;
import minicdj.util.List;
import minicdj.util.RandomAccess;

public class Arrays {
    private Arrays() {
    }

    public static int binarySearch(byte[] a, byte key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            byte d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(char[] a, char key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            char d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(short[] a, short key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            short d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(int[] a, int key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            int d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(long[] a, long key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            long d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(float[] a, float key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            int r = Float.compare(a[mid], key);
            if (r == 0) {
                return mid;
            }
            if (r > 0) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(double[] a, double key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            int r = Double.compare(a[mid], key);
            if (r == 0) {
                return mid;
            }
            if (r > 0) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static boolean equals(boolean[] a1, boolean[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(byte[] a1, byte[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(char[] a1, char[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(short[] a1, short[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(int[] a1, int[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(long[] a1, long[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(float[] a1, float[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (Float.compare(a1[i], a2[i]) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(double[] a1, double[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (Double.compare(a1[i], a2[i]) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(Object[] a1, Object[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (AbstractCollection.equals(a1[i], a2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void fill(boolean[] a, boolean val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(boolean[] a, int fromIndex, int toIndex, boolean val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(byte[] a, byte val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(byte[] a, int fromIndex, int toIndex, byte val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(char[] a, char val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(char[] a, int fromIndex, int toIndex, char val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(short[] a, short val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(short[] a, int fromIndex, int toIndex, short val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(int[] a, int val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(int[] a, int fromIndex, int toIndex, int val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(long[] a, long val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(long[] a, int fromIndex, int toIndex, long val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(float[] a, float val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(float[] a, int fromIndex, int toIndex, float val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(double[] a, double val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(double[] a, int fromIndex, int toIndex, double val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(Object[] a, Object val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(Object[] a, int fromIndex, int toIndex, Object val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void sort(byte[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(byte[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static int med3(int a, int b, int c, byte[] d) {
        return d[a] < d[b] ? (d[b] < d[c] ? b : (d[a] < d[c] ? c : a)) : (d[b] > d[c] ? b : (d[a] > d[c] ? c : a));
    }

    private static void swap(int i, int j, byte[] a) {
        byte c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void vecswap(int i, int j, int n, byte[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static void qsort(byte[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && array[j - 1] > array[j]) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = array[b] - array[from]) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = array[c] - array[from]) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(char[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(char[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static int med3(int a, int b, int c, char[] d) {
        return d[a] < d[b] ? (d[b] < d[c] ? b : (d[a] < d[c] ? c : a)) : (d[b] > d[c] ? b : (d[a] > d[c] ? c : a));
    }

    private static void swap(int i, int j, char[] a) {
        char c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void vecswap(int i, int j, int n, char[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static void qsort(char[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && array[j - 1] > array[j]) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = array[b] - array[from]) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = array[c] - array[from]) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(short[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(short[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static int med3(int a, int b, int c, short[] d) {
        return d[a] < d[b] ? (d[b] < d[c] ? b : (d[a] < d[c] ? c : a)) : (d[b] > d[c] ? b : (d[a] > d[c] ? c : a));
    }

    private static void swap(int i, int j, short[] a) {
        short c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void vecswap(int i, int j, int n, short[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static void qsort(short[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && array[j - 1] > array[j]) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = array[b] - array[from]) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = array[c] - array[from]) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(int[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(int[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static int med3(int a, int b, int c, int[] d) {
        return d[a] < d[b] ? (d[b] < d[c] ? b : (d[a] < d[c] ? c : a)) : (d[b] > d[c] ? b : (d[a] > d[c] ? c : a));
    }

    private static void swap(int i, int j, int[] a) {
        int c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void vecswap(int i, int j, int n, int[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static int compare(int a, int b) {
        return a < b ? -1 : (a == b ? 0 : 1);
    }

    private static void qsort(int[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && array[j - 1] > array[j]) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = Arrays.compare(array[b], array[from])) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = Arrays.compare(array[c], array[from])) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(long[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(long[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static int med3(int a, int b, int c, long[] d) {
        return d[a] < d[b] ? (d[b] < d[c] ? b : (d[a] < d[c] ? c : a)) : (d[b] > d[c] ? b : (d[a] > d[c] ? c : a));
    }

    private static void swap(int i, int j, long[] a) {
        long c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void vecswap(int i, int j, int n, long[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static int compare(long a, long b) {
        return a < b ? -1 : (a == b ? 0 : 1);
    }

    private static void qsort(long[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && array[j - 1] > array[j]) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = Arrays.compare(array[b], array[from])) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = Arrays.compare(array[c], array[from])) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(float[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(float[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static int med3(int a, int b, int c, float[] d) {
        return Float.compare(d[a], d[b]) < 0 ? (Float.compare(d[b], d[c]) < 0 ? b : (Float.compare(d[a], d[c]) < 0 ? c : a)) : (Float.compare(d[b], d[c]) > 0 ? b : (Float.compare(d[a], d[c]) > 0 ? c : a));
    }

    private static void swap(int i, int j, float[] a) {
        float c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void vecswap(int i, int j, int n, float[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static void qsort(float[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && Float.compare(array[j - 1], array[j]) > 0) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = Float.compare(array[b], array[from])) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = Float.compare(array[c], array[from])) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(double[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(double[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static int med3(int a, int b, int c, double[] d) {
        return Double.compare(d[a], d[b]) < 0 ? (Double.compare(d[b], d[c]) < 0 ? b : (Double.compare(d[a], d[c]) < 0 ? c : a)) : (Double.compare(d[b], d[c]) > 0 ? b : (Double.compare(d[a], d[c]) > 0 ? c : a));
    }

    private static void swap(int i, int j, double[] a) {
        double c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void vecswap(int i, int j, int n, double[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static void qsort(double[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && Double.compare(array[j - 1], array[j]) > 0) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = Double.compare(array[b], array[from])) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = Double.compare(array[c], array[from])) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static List asList(Object[] a) {
        return new ArrayList(a);
    }

    public static String toString(long[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        String result = "[";
        int i = 0;
        while (i < a.length - 1) {
            result = String.valueOf(result) + String.valueOf(a[i]) + ", ";
            ++i;
        }
        result = String.valueOf(result) + String.valueOf(a[a.length - 1]) + "]";
        return result;
    }

    public static String toString(int[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        String result = "[";
        int i = 0;
        while (i < a.length - 1) {
            result = String.valueOf(result) + String.valueOf(a[i]) + ", ";
            ++i;
        }
        result = String.valueOf(result) + String.valueOf(a[a.length - 1]) + "]";
        return result;
    }

    public static String toString(short[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        String result = "[";
        int i = 0;
        while (i < a.length - 1) {
            result = String.valueOf(result) + String.valueOf(a[i]) + ", ";
            ++i;
        }
        result = String.valueOf(result) + String.valueOf(a[a.length - 1]) + "]";
        return result;
    }

    public static String toString(char[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        String result = "[";
        int i = 0;
        while (i < a.length - 1) {
            result = String.valueOf(result) + String.valueOf(a[i]) + ", ";
            ++i;
        }
        result = String.valueOf(result) + String.valueOf(a[a.length - 1]) + "]";
        return result;
    }

    public static String toString(byte[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        String result = "[";
        int i = 0;
        while (i < a.length - 1) {
            result = String.valueOf(result) + String.valueOf(a[i]) + ", ";
            ++i;
        }
        result = String.valueOf(result) + String.valueOf(a[a.length - 1]) + "]";
        return result;
    }

    public static String toString(boolean[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        String result = "[";
        int i = 0;
        while (i < a.length - 1) {
            result = String.valueOf(result) + String.valueOf(a[i]) + ", ";
            ++i;
        }
        result = String.valueOf(result) + String.valueOf(a[a.length - 1]) + "]";
        return result;
    }

    public static String toString(float[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        String result = "[";
        int i = 0;
        while (i < a.length - 1) {
            result = String.valueOf(result) + String.valueOf(a[i]) + ", ";
            ++i;
        }
        result = String.valueOf(result) + String.valueOf(a[a.length - 1]) + "]";
        return result;
    }

    public static String toString(double[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        String result = "[";
        int i = 0;
        while (i < a.length - 1) {
            result = String.valueOf(result) + String.valueOf(a[i]) + ", ";
            ++i;
        }
        result = String.valueOf(result) + String.valueOf(a[a.length - 1]) + "]";
        return result;
    }

    public static String toString(Object[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        String result = "[";
        int i = 0;
        while (i < a.length - 1) {
            result = String.valueOf(result) + String.valueOf(a[i]) + ", ";
            ++i;
        }
        result = String.valueOf(result) + String.valueOf(a[a.length - 1]) + "]";
        return result;
    }

    private static final class ArrayList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = -2764017481108945198L;
        private final Object[] a;

        ArrayList(Object[] a) {
            if (a == null) {
                throw new NullPointerException();
            }
            this.a = a;
        }

        @Override
        public Object get(int index) {
            return this.a[index];
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public Object set(int index, Object element) {
            Object old = this.a[index];
            this.a[index] = element;
            return old;
        }

        @Override
        public boolean contains(Object o) {
            return this.lastIndexOf(o) >= 0;
        }

        @Override
        public int indexOf(Object o) {
            int size = this.a.length;
            int i = 0;
            while (i < size) {
                if (ArrayList.equals(o, this.a[i])) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            int i = this.a.length;
            while (--i >= 0) {
                if (!ArrayList.equals(o, this.a[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.a.clone();
        }

        @Override
        public Object[] toArray(Object[] array) {
            int size = this.a.length;
            if (array.length < size) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            } else if (array.length > size) {
                array[size] = null;
            }
            System.arraycopy(this.a, 0, array, 0, size);
            return array;
        }
    }
}

