/*
 * Decompiled with CFR 0.152.
 */
package minicdj.cdx;

import minicdj.cdx.Vector2d;
import minicdj.cdx.ZeroVectorException;
import minicdj.collision.Vector3d;

final class VectorMath {
    VectorMath() {
    }

    public static void add(Vector3d a, Vector3d b, Vector3d dest) {
        dest.x = a.x + b.x;
        dest.y = a.y + b.y;
        dest.z = a.z + b.z;
    }

    public static void subtract(Vector3d a, Vector3d b, Vector3d dest) {
        dest.x = a.x - b.x;
        dest.y = a.y - b.y;
        dest.z = a.z - b.z;
    }

    public static void scale(Vector3d a, float scale, Vector3d dest) {
        dest.x = a.x * scale;
        dest.y = a.y * scale;
        dest.z = a.z * scale;
    }

    public static void normalize(Vector3d a, Vector3d dest) {
        float mag = VectorMath.magnitude(a);
        if (mag == 0.0f) {
            throw new ZeroVectorException("undefined");
        }
        VectorMath.scale(a, 1.0f / mag, dest);
    }

    public static float magnitude(Vector3d a) {
        return (float)Math.sqrt(a.x * a.x + a.y * a.y + a.z * a.z);
    }

    public static float distance(Vector3d a, Vector3d b) {
        float dx = a.x - b.x;
        float dy = a.y - b.y;
        float dz = a.z - b.z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static float sqDistance(Vector3d a, Vector3d b) {
        float dx = a.x - b.x;
        float dy = a.y - b.y;
        float dz = a.z - b.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public static float dotProduct(Vector3d a, Vector3d b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static void rotate(Vector3d a, float radians, Vector3d dest) {
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        float x = a.x;
        float y = a.y;
        dest.x = x * cos - y * sin;
        dest.y = x * sin + y * cos;
        dest.z = a.z;
    }

    public static float theta(Vector3d a) {
        float x = a.x;
        float y = a.y;
        if (x == 0.0f) {
            if (y == 0.0f) {
                throw new ZeroVectorException("undefined");
            }
            if (y < 0.0f) {
                return 4.712389f;
            }
            return 1.5707964f;
        }
        float t = (float)Math.atan(y / x);
        if (x < 0.0f) {
            return (float)Math.PI - t;
        }
        if (t < 0.0f) {
            t = (float)((double)t + Math.PI * 2);
        }
        return t;
    }

    public static float phi(Vector3d a) {
        float x = a.x;
        float y = a.y;
        float z = a.z;
        if (x == 0.0f && y == 0.0f) {
            if (z == 0.0f) {
                throw new ZeroVectorException("undefined");
            }
            if (z < 0.0f) {
                return -1.5707964f;
            }
            return 1.5707964f;
        }
        float h = (float)Math.sqrt(x * x + y * y);
        float t = (float)Math.atan(y / h);
        return t;
    }

    public static void add(Vector2d a, Vector2d b, Vector2d dest) {
        dest.x = a.x + b.x;
        dest.y = a.y + b.y;
    }

    public static void subtract(Vector2d a, Vector2d b, Vector2d dest) {
        dest.x = a.x - b.x;
        dest.y = a.y - b.y;
    }

    public static void scale(Vector2d a, float scale, Vector2d dest) {
        dest.x = a.x * scale;
        dest.y = a.y * scale;
    }

    public static void normalize(Vector2d a, Vector2d dest) {
        float mag = VectorMath.magnitude(a);
        if (mag == 0.0f) {
            throw new ZeroVectorException("undefined");
        }
        VectorMath.scale(a, 1.0f / mag, dest);
    }

    public static float magnitude(Vector2d a) {
        return (float)Math.sqrt(a.x * a.x + a.y * a.y);
    }

    public static float distance(Vector2d a, Vector2d b) {
        float dx = a.x - b.x;
        float dy = a.y - b.y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static float sqDistance(Vector2d a, Vector2d b) {
        float dx = a.x - b.x;
        float dy = a.y - b.y;
        return dx * dx + dy * dy;
    }

    public static float dotProduct(Vector2d a, Vector2d b) {
        return a.x * b.x + a.y * b.y;
    }

    public static int quadrant(Vector2d a) {
        float x = a.x;
        float y = a.y;
        float xy = x * y;
        if (xy == 0.0f) {
            return 0;
        }
        if (xy > 0.0f) {
            if (x > 0.0f) {
                return 1;
            }
            return 3;
        }
        if (x < 0.0f) {
            return 2;
        }
        return 4;
    }

    public static void convert(Vector3d src, Vector2d dest) {
        dest.x = src.x;
        dest.y = src.y;
    }

    public static void convert(Vector2d src, Vector3d dest) {
        dest.x = src.x;
        dest.y = src.y;
        dest.z = 0.0f;
    }

    public static float distance(Vector3d a, Vector2d b) {
        float dx = a.x - b.x;
        float dy = a.y - b.y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static float distance(Vector2d a, Vector3d b) {
        float dx = a.x - b.x;
        float dy = a.y - b.y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static float sqDistance(Vector3d a, Vector2d b) {
        float dx = a.x - b.x;
        float dy = a.y - b.y;
        return dx * dx + dy * dy;
    }

    public static float sqDistance(Vector2d a, Vector3d b) {
        float dx = a.x - b.x;
        float dy = a.y - b.y;
        return dx * dx + dy * dy;
    }
}

