/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical.extension;

import javax.realtime.AbsoluteTime;
import javax.realtime.AperiodicParameters;
import javax.realtime.Clock;
import javax.realtime.HighResolutionTime;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.realtime.ReleaseParameters;
import javax.safetycritical.Services;
import javax.safetycritical.StorageParameters;
import javax.safetycritical.extension.ManagedRealtimeThread;

public abstract class OneShotThread
extends ManagedRealtimeThread {
    private HighResolutionTime startTime;
    private AperiodicParameters release;

    public OneShotThread(PriorityParameters priority, StorageParameters storage, AperiodicParameters release, HighResolutionTime startTime, boolean isAutoStart, String name) {
        super(priority, storage, isAutoStart, name);
        this.release = release;
        this.startTime = startTime;
    }

    @Override
    public final void run() {
        if (this.startTime instanceof AbsoluteTime) {
            Services.delay(new AbsoluteTime((AbsoluteTime)this.startTime));
        }
        if (this.startTime instanceof RelativeTime) {
            Services.delay(new AbsoluteTime(this.startTime.getMilliseconds(), this.startTime.getNanoseconds(), Clock.getRealtimeClock()));
        }
        this.work();
    }

    @Override
    public ReleaseParameters getReleaseParameter() {
        return this.release;
    }

    @Override
    public final void cleanUp() {
        super.cleanUp();
    }

    public HighResolutionTime getStartTime() {
        return this.startTime;
    }
}

