/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import devices.Console;
import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.realtime.RtProcess;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.OneShotEventHandler;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.StorageParameters;
import javax.scj.util.Const;
import vm.Process;
import vm.ProcessLogic;
import vm.RealtimeClock;

final class ScjProcess
extends RtProcess {
    ScjProcess(ManagedSchedulable ms, int[] stack) {
        this.next = new AbsoluteTime(rtClock);
        this.target = ms;
        this.state = 0;
        this.process = new Process(new ProcessLogic(){

            @Override
            public void run() {
                try {
                    try {
                        ScjProcess.this.getTarget().getManagedMemory().enter(ScjProcess.this.getTarget());
                    }
                    catch (Exception e) {
                        Console.println("ScjProcess: exception -> " + e);
                        if (ScjProcess.this.getTarget() instanceof PeriodicEventHandler) {
                            ScjProcess.this.next.add(ScjProcess.this.period, ScjProcess.this.next);
                        }
                        ScjProcess.this.state = 5;
                    }
                }
                finally {
                    if (ScjProcess.this.getTarget() instanceof PeriodicEventHandler) {
                        ScjProcess.this.next.add(ScjProcess.this.period, ScjProcess.this.next);
                    }
                    ScjProcess.this.state = 5;
                }
            }

            @Override
            public void catchError(Throwable t) {
                Console.println("ScjProcess: exception -> " + t);
            }
        }, stack);
        this.process.initialize();
        rtClock.getTime(this.next);
        if (this.getTarget() instanceof PeriodicEventHandler) {
            this.start = ((PeriodicParameters)this.getTarget().getReleaseParameter()).getStart();
            this.period = ((PeriodicParameters)this.getTarget().getReleaseParameter()).getPeriod();
            this.next.add(this.start, this.next);
        } else if (this.getTarget() instanceof OneShotEventHandler) {
            if (((OneShotEventHandler)this.getTarget()).releaseTime instanceof RelativeTime) {
                RelativeTime releaseTime = (RelativeTime)((OneShotEventHandler)this.getTarget()).releaseTime;
                this.next.add(releaseTime, this.next);
            } else {
                AbsoluteTime releaseTime = (AbsoluteTime)((OneShotEventHandler)this.getTarget()).releaseTime;
                int compare = releaseTime.compareTo(Clock.getRealtimeClock().getTime(new AbsoluteTime(rtClock)));
                if (compare < 0) {
                    this.next.add(new RelativeTime(), this.next);
                } else {
                    this.next.set(releaseTime);
                }
            }
        }
        this.getTarget().setScjProcess(this);
    }

    static RtProcess createIdleProcess() {
        if (idleProcess == null) {
            PeriodicEventHandler peh = new PeriodicEventHandler(new PriorityParameters(1), new PeriodicParameters(new RelativeTime(Clock.getRealtimeClock()), Const.INFINITE_TIME), new StorageParameters(40000L, new long[]{Const.IDLE_PROCESS_STACK_SIZE}, 40000L, 120000L, 200000L), "idle"){

                @Override
                public void handleAsyncEvent() {
                    Console.println("Idle");
                    this.yield();
                }

                private void yield() {
                    while (true) {
                        RealtimeClock.awaitNextTick();
                    }
                }
            };
            ScjProcess process = new ScjProcess(peh, new int[Const.IDLE_PROCESS_STACK_SIZE]);
            process.setIndex(-1);
            idleProcess = process;
        }
        return idleProcess;
    }

    @Override
    protected void start() {
        this.process.initialize();
    }

    protected ManagedSchedulable getTarget() {
        return this.target;
    }

    protected int getIndex() {
        return this.index;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    protected int getState() {
        return this.state;
    }

    protected void setState(int state) {
        this.state = state;
    }

    protected Process getProcess() {
        return this.process;
    }

    protected AbsoluteTime getNext() {
        return this.next;
    }

    @Override
    protected String print() {
        return "name: " + this.target.getName() + " \tindex: " + this.index;
    }

    protected static interface State
    extends RtProcess.State {
    }
}

