/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import icecaptools.IcecapCompileMe;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.ScjProcess;
import vm.ClockInterruptHandler;
import vm.InterruptHandler;

final class Monitor
extends javax.realtime.Monitor {
    private int ceiling;
    private int synchCounter;
    private int priority;
    private ManagedSchedulable owner;
    private InterruptHandler clock;

    protected Monitor(int ceiling) {
        this.ceiling = ceiling;
        this.clock = ClockInterruptHandler.instance;
    }

    @Override
    @IcecapCompileMe
    protected void lock() {
        this.clock.disable();
        ManagedSchedulable ms = PriorityScheduler.instance().getCurrentProcess().getTarget();
        if (this.owner == null) {
            this.owner = ms;
        }
        if (this.owner == ms) {
            ++this.synchCounter;
            if (this.synchCounter == 1) {
                this.priority = ms.getPriorityParameter().getPriority();
                ms.getPriorityParameter().setPriority(Monitor.max(this.priority, this.ceiling) + 1);
            }
        } else {
            PriorityScheduler.instance().addProcessToLockQueue(this, ms.getScjProcess());
            PriorityScheduler.instance().moveToNext();
            ClockInterruptHandler.instance.enable();
            ClockInterruptHandler.instance.handle();
        }
        this.clock.enable();
    }

    @Override
    @IcecapCompileMe
    protected void unlock() {
        this.clock.disable();
        ManagedSchedulable ms = PriorityScheduler.instance().getCurrentProcess().getTarget();
        if (this.owner == ms) {
            --this.synchCounter;
            if (this.synchCounter == 0) {
                ms.getPriorityParameter().setPriority(this.priority);
                ScjProcess process = PriorityScheduler.instance().getProcessFromLockQueue(this);
                if (process != null) {
                    this.owner = process.getTarget();
                    ++this.synchCounter;
                    this.priority = this.owner.getPriorityParameter().getPriority();
                    this.owner.getPriorityParameter().setPriority(Monitor.max(this.priority, this.ceiling) + 1);
                    PriorityScheduler.instance().insertReleaseQueue(process);
                } else {
                    this.owner = null;
                }
                this.clock.enable();
                this.clock.handle();
            }
        } else {
            this.clock.enable();
            throw new IllegalMonitorStateException();
        }
    }

    @Override
    protected void lockWithOutEnable() {
        ClockInterruptHandler.instance.disable();
        ManagedSchedulable ms = PriorityScheduler.instance().getCurrentProcess().getTarget();
        if (this.owner == null) {
            this.owner = ms;
        }
        if (this.owner == ms) {
            ++this.synchCounter;
            if (this.synchCounter == 1) {
                this.priority = this.owner.getPriorityParameter().getPriority();
                this.owner.getPriorityParameter().setPriority(Monitor.max(this.priority, this.ceiling) + 1);
            }
        } else {
            PriorityScheduler.instance().addProcessToLockQueue(this, ms.getScjProcess());
            PriorityScheduler.instance().moveToNext();
            ClockInterruptHandler.instance.enable();
            ClockInterruptHandler.instance.handle();
        }
    }

    @Override
    protected void unlockWithOutEnable() {
        ManagedSchedulable ms = PriorityScheduler.instance().getCurrentProcess().getTarget();
        if (this.owner == ms) {
            --this.synchCounter;
            if (this.synchCounter == 0) {
                ms.getPriorityParameter().setPriority(this.priority);
                ScjProcess nextProcess = PriorityScheduler.instance().getProcessFromLockQueue(this);
                if (nextProcess != null) {
                    this.owner = nextProcess.getTarget();
                    ++this.synchCounter;
                    this.priority = this.owner.getPriorityParameter().getPriority();
                    this.owner.getPriorityParameter().setPriority(Monitor.max(this.priority, this.ceiling) + 1);
                    PriorityScheduler.instance().insertReleaseQueue(nextProcess);
                } else {
                    this.owner = null;
                }
            }
        } else {
            this.clock.enable();
            throw new IllegalMonitorStateException();
        }
    }

    private static int max(int x, int y) {
        if (x > y) {
            return x;
        }
        return y;
    }
}

