/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.Monitor;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.ScjProcess;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import javax.scj.util.Const;

@SCJAllowed(value=Level.INFRASTRUCTURE)
class ManagedSchedulableSet {
    ManagedSchedulable[] MSOs = new ManagedSchedulable[Const.DEFAULT_HANDLER_NUMBER];
    int noOfRegistered = 0;
    ScjProcess[] scjProcesses = new ScjProcess[Const.DEFAULT_HANDLER_NUMBER];
    int noOfActived = 0;

    ManagedSchedulableSet() {
    }

    void addMS(ManagedSchedulable ms) {
        if (!this.contains(ms)) {
            this.MSOs[this.noOfRegistered] = ms;
            ++this.noOfRegistered;
            ++this.noOfActived;
        }
    }

    boolean contains(ManagedSchedulable ms) {
        int i = 0;
        while (i < this.noOfRegistered) {
            if (this.MSOs[i] == ms) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void terminateMSOs() {
        int i = this.noOfRegistered;
        while (i > 0) {
            this.MSOs[i - 1].cleanUp();
            this.MSOs[i - 1] = null;
            --this.noOfActived;
            --i;
        }
    }

    void removeMSO(ManagedSchedulable ms) {
        int i = 0;
        while (i < this.noOfRegistered) {
            if (this.MSOs[i] == ms) {
                this.MSOs[i].cleanUp();
                this.MSOs[i] = null;
                PriorityScheduler.instance().removeReleaseQueue(this.scjProcesses[i]);
                this.scjProcesses[i] = null;
                --this.noOfActived;
            }
            ++i;
        }
        if (this.noOfActived == 0) {
            Monitor lock = ms.getMission().getSequencer().getLock();
            lock.lockWithOutEnable();
            PriorityScheduler.instance().notifyForMS(lock);
            lock.unlockWithOutEnable();
        }
    }

    void removeAperiodicHandlers() {
        int i = 0;
        while (i < this.noOfRegistered) {
            if (this.MSOs[i] instanceof AperiodicEventHandler) {
                this.MSOs[i].cleanUp();
                PriorityScheduler.instance().removeReleaseQueue(this.scjProcesses[i]);
                --this.noOfActived;
            }
            if (this.noOfActived == 0) {
                Monitor lock = this.MSOs[i].getMission().getSequencer().getLock();
                lock.lockWithOutEnable();
                PriorityScheduler.instance().notifyForMS(lock);
                lock.unlockWithOutEnable();
            }
            ++i;
        }
    }

    int indexOf(ManagedSchedulable ms) {
        int i = 0;
        while (i < this.noOfRegistered) {
            if (this.MSOs[i] == ms) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        return "Mission: " + this.noOfRegistered + " managed schedule objects.";
    }
}

