/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.AbsoluteTime;
import javax.realtime.BoundAsyncEventHandler;
import javax.realtime.MemoryArea;
import javax.realtime.PriorityParameters;
import javax.realtime.ReleaseParameters;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.ManagedSchedulableSet;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionMemory;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.PrivateMemory;
import javax.safetycritical.ScjProcess;
import javax.safetycritical.StorageParameters;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.Phase;
import javax.safetycritical.annotate.SCJAllowed;
import javax.safetycritical.annotate.SCJRestricted;

@SCJAllowed
public abstract class ManagedEventHandler
extends BoundAsyncEventHandler
implements ManagedSchedulable {
    StorageParameters storage;
    Mission mission = null;
    ManagedMemory privateMemory;
    MemoryArea currentMemory;
    MemoryArea topMemory;
    ScjProcess process;
    static StorageParameters defaultStorage = new StorageParameters(40000L, new long[]{2048L}, 40000L, 120000L, 200000L);

    public ManagedEventHandler(PriorityParameters priority, ReleaseParameters release, StorageParameters storage, String name) {
        super(priority, release, name);
        if (storage == null) {
            throw new IllegalArgumentException("storage is null");
        }
        this.storage = storage;
        this.mission = Mission.getCurrentMission();
        int backingStoreOfThisMemory = this.mission == null && this instanceof MissionSequencer ? MemoryArea.getRemainingMemorySize() : (int)this.storage.totalBackingStore;
        MissionMemory backingStoreProvider = this.mission == null ? null : this.mission.missionSeq.missionMemory;
        this.privateMemory = new PrivateMemory((int)this.storage.getMaxMemoryArea(), backingStoreOfThisMemory, backingStoreProvider);
        this.topMemory = this.currentMemory = this.privateMemory;
    }

    @Override
    public abstract void handleAsyncEvent();

    @Override
    @SCJAllowed(value=Level.SUPPORT)
    @SCJRestricted(value=Phase.CLEANUP)
    public void cleanUp() {
        this.privateMemory.removeArea();
    }

    @Override
    @SCJAllowed(value=Level.INFRASTRUCTURE)
    @SCJRestricted(value=Phase.INITIALIZE)
    public void register() {
        ManagedSchedulableSet hs = this.mission.MSSetForMission;
        hs.addMS(this);
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public AbsoluteTime getLastReleaseTime() {
        return null;
    }

    @Override
    public StorageParameters getStorageParameter() {
        return this.storage;
    }

    @Override
    public ManagedMemory getManagedMemory() {
        return this.privateMemory;
    }

    @Override
    public ScjProcess getScjProcess() {
        return this.process;
    }

    @Override
    public void setScjProcess(ScjProcess process) {
        this.process = process;
    }

    @Override
    public Mission getMission() {
        return this.mission;
    }

    @Override
    public void setMission(Mission m) {
        this.mission = m;
    }

    @Override
    public void signalTermination() {
    }

    @Override
    public void setCurrentMemory(MemoryArea current) {
        this.currentMemory = current;
    }

    @Override
    public MemoryArea getCurrentMemory() {
        return this.currentMemory;
    }

    @Override
    public void setTopMemory(MemoryArea topMemory) {
        this.topMemory = topMemory;
    }

    @Override
    public MemoryArea getTopMemory() {
        return this.topMemory;
    }
}

