/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import devices.Console;
import javax.realtime.ImmortalMemory;
import javax.safetycritical.CyclicScheduler;
import javax.safetycritical.InterfaceProvider;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.Safelet;
import javax.safetycritical.ScjProcess;
import javax.scj.util.Const;

public class Launcher
implements Runnable {
    Safelet<?> app;
    static int level;

    public Launcher(Safelet<?> app, int level) {
        this.app = app;
        Launcher.level = level;
        ManagedMemory.allocateBackingStore(Const.BACKING_STORE_SIZE);
        ImmortalMemory immortalMem = ImmortalMemory.instance();
        InterfaceProvider.instance().executeInImmortal(immortalMem, this);
        Console.println("application finished");
    }

    @Override
    public void run() {
        if (this.app.immortalMemorySize() > ImmortalMemory.instance().memoryRemaining()) {
            Console.println("immortal size is not enough");
            return;
        }
        this.app.initializeApplication();
        if (level != 0) {
            PriorityScheduler sch = PriorityScheduler.instance();
            sch.insertReleaseQueue(ScjProcess.createIdleProcess());
            this.app.getSequencer();
            sch.start();
        } else {
            CyclicScheduler.instance().start(this.app.getSequencer());
        }
    }
}

