/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import devices.Console;
import javax.realtime.PriorityScheduler;
import javax.realtime.RtProcess;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed(value=Level.INFRASTRUCTURE)
class ReleaseQueue {
    int heapSize = 0;
    protected int[] tree;

    public ReleaseQueue(int size) {
        this.tree = new int[size + 1];
        this.makeEmptyTree(this.tree);
    }

    private void makeEmptyTree(int[] tree) {
        int i = 0;
        while (i < tree.length) {
            tree[i] = -999;
            ++i;
        }
    }

    int parent(int i) {
        return i / 2;
    }

    int left(int i) {
        return 2 * i;
    }

    int right(int i) {
        return 2 * i + 1;
    }

    void exchange(int a, int b) {
        int temp = this.tree[a];
        this.tree[a] = this.tree[b];
        this.tree[b] = temp;
    }

    void heapify(int i) {
        int l = this.left(i);
        int r = this.right(i);
        int smallest = l <= this.heapSize && this.getRtProcess(this.tree[l]).compareTo(this.getRtProcess(this.tree[r])) < 0 ? l : i;
        if (r <= this.heapSize && this.getRtProcess(this.tree[r]).compareTo(this.getRtProcess(this.tree[smallest])) < 0) {
            smallest = r;
        }
        if (smallest != i) {
            this.exchange(i, smallest);
            this.heapify(smallest);
        }
    }

    public void insert(RtProcess obj) {
        if (this.heapSize + 1 == this.tree.length) {
            throw new IndexOutOfBoundsException("ReleaseQueue: too small");
        }
        ++this.heapSize;
        int i = this.heapSize;
        while (i > 1 && this.getRtProcess(this.tree[this.parent(i)]).compareTo(obj) > 0) {
            this.tree[i] = this.tree[this.parent(i)];
            i = this.parent(i);
        }
        this.tree[i] = obj.index;
    }

    public RtProcess extractMin() {
        if (this.heapSize < 1) {
            return null;
        }
        RtProcess min = this.getRtProcess(this.tree[1]);
        this.tree[1] = this.tree[this.heapSize];
        --this.heapSize;
        this.heapify(1);
        return min;
    }

    private RtProcess getRtProcess(int processIdx) {
        if (processIdx == -999) {
            return null;
        }
        if (processIdx == -2) {
            return PriorityScheduler.instance().outerMostSeqProcess;
        }
        if (processIdx == -1) {
            return RtProcess.idleProcess;
        }
        int missionIndex = processIdx / 20;
        int scjProcessIndex = processIdx % 20;
        return PriorityScheduler.instance().getProcess(missionIndex, scjProcessIndex);
    }

    public void remove(RtProcess obj) {
        if (obj == null) {
            return;
        }
        int i = this.find(obj.index);
        if (i != -999) {
            this.tree[i] = this.tree[this.heapSize];
            --this.heapSize;
            this.heapify(i);
        }
    }

    private int find(int value) {
        int i = 1;
        while (i <= this.heapSize) {
            if (this.tree[i] == value) {
                return i;
            }
            ++i;
        }
        return -999;
    }

    void print() {
        Console.println("Queue size = " + this.heapSize);
        int i = 0;
        while (i < this.tree.length) {
            Console.print("[ " + this.tree[i] + " ] ");
            ++i;
        }
        Console.println("");
        i = 1;
        while (i <= this.heapSize) {
            RtProcess process = this.getRtProcess(this.tree[i]);
            if (process != null) {
                Console.println("name: " + process.target.getName());
            } else {
                Console.println("null process");
            }
            ++i;
        }
    }
}

