/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.HighResolutionTime;
import javax.realtime.PriorityParameters;
import javax.realtime.PriorityScheduler;
import javax.realtime.RelativeTime;
import javax.realtime.ReleaseParameters;
import javax.realtime.RtProcess;
import javax.realtime.Schedulable;
import vm.ClockInterruptHandler;

public class RealtimeThread
implements Schedulable {
    Runnable logic;
    PriorityParameters priority;
    String name;

    protected RealtimeThread(PriorityParameters priority, Runnable logic, String name) {
        if (priority == null) {
            throw new IllegalArgumentException("priority is null");
        }
        this.priority = priority;
        this.logic = logic;
        this.name = name;
    }

    @Override
    public void run() {
        if (this.logic != null) {
            this.logic.run();
        }
    }

    @Override
    public PriorityParameters getPriorityParameter() {
        return this.priority;
    }

    @Override
    public ReleaseParameters getReleaseParameter() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void sleep(HighResolutionTime time) throws InterruptedException {
        ClockInterruptHandler.instance.disable();
        RtProcess current = PriorityScheduler.instance().current;
        AbsoluteTime abs = Clock.getRealtimeClock().getTime(current.next);
        if (time instanceof RelativeTime) {
            current.next = abs.add((RelativeTime)time, abs);
        } else if (time instanceof AbsoluteTime) {
            current.next = new AbsoluteTime((AbsoluteTime)time);
        } else {
            throw new UnsupportedOperationException();
        }
        RtProcess nextProcess = PriorityScheduler.instance().pFrame.queue.extractMin();
        nextProcess.state = 2;
        PriorityScheduler.instance().current = nextProcess;
        PriorityScheduler.instance().pFrame.queue.insert(current);
        ClockInterruptHandler.instance.enable();
        ClockInterruptHandler.instance.yield();
    }
}

