/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.RelativeTime;

public class RealtimeClock
extends Clock {
    private static vm.RealtimeClock nativeClock = vm.RealtimeClock.getRealtimeClock();
    private static Clock rtClock;
    private static RelativeTime resolution;

    RealtimeClock() {
        super(true);
    }

    private static RelativeTime setResolution() {
        int granularity = nativeClock.getGranularity();
        long millis = granularity / 1000000;
        int nanos = granularity % 1000000;
        return new RelativeTime(millis, nanos, rtClock);
    }

    static Clock instance() {
        if (rtClock == null) {
            rtClock = new RealtimeClock();
            resolution = RealtimeClock.setResolution();
        }
        return rtClock;
    }

    @Override
    public RelativeTime getEpochOffset() {
        return new RelativeTime(0L, 0, this);
    }

    @Override
    public RelativeTime getResolution() {
        return new RelativeTime(resolution);
    }

    @Override
    public RelativeTime getResolution(RelativeTime dest) {
        if (dest == null) {
            return this.getResolution();
        }
        dest.set(resolution.getMilliseconds(), resolution.getNanoseconds());
        dest.clock = rtClock;
        return dest;
    }

    @Override
    public AbsoluteTime getTime() {
        return this.getTime(new AbsoluteTime(0L, 0, this));
    }

    @Override
    public AbsoluteTime getTime(AbsoluteTime dest) {
        if (dest == null) {
            dest = new AbsoluteTime();
        }
        nativeClock.getCurrentTime(dest);
        dest.clock = rtClock;
        return dest;
    }
}

