/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityQueue;
import javax.realtime.RelativeTime;
import javax.realtime.ReleaseQueue;
import javax.realtime.RtProcess;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.ManagedThread;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.OneShotEventHandler;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed(value=Level.INFRASTRUCTURE)
class PriorityFrame {
    ReleaseQueue queue;
    PriorityQueue waitQueue;
    PriorityQueue lockQueue;

    PriorityFrame(int queueSize) {
        this.queue = new ReleaseQueue(queueSize);
        this.waitQueue = new PriorityQueue(queueSize);
        this.lockQueue = new PriorityQueue(queueSize);
    }

    void addProcess(RtProcess process) {
        if (process.target instanceof MissionSequencer) {
            process.state = 1;
            this.queue.insert(process);
        } else if (process.target instanceof PeriodicEventHandler) {
            PeriodicEventHandler pevh = (PeriodicEventHandler)process.target;
            RelativeTime start = ((PeriodicParameters)pevh.getReleaseParameter()).getStart();
            process.state = start.getMilliseconds() == 0L && start.getNanoseconds() == 0 ? 1 : 4;
            this.queue.insert(process);
        } else if (process.target instanceof AperiodicEventHandler) {
            process.state = 3;
        } else if (process.target instanceof OneShotEventHandler) {
            process.state = 4;
            this.queue.insert(process);
        } else if (process.target instanceof ManagedThread) {
            if (((ManagedThread)process.target).isAutoStart()) {
                process.state = 1;
                this.queue.insert(process);
            } else {
                process.state = 3;
            }
        } else {
            throw new IllegalArgumentException("PriorityFrame.addHandler: UPS: another schedulable objects??");
        }
    }
}

