/*
 * Decompiled with CFR 0.152.
 */
package devices.NXT;

import devices.NXT.AT91_REG;
import devices.NXT.C64Font;
import devices.NXT.SPI;
import reflect.ObjectInfo;

public class Display {
    private static AT91_REG AT91C_PIOA_SODR;
    private static AT91_REG AT91C_PIOA_CODR;
    private byte[] buf;
    private static SPI spi;
    private static byte[][] displayLineNumbers;

    static {
        byte[][] byArrayArray = new byte[8][];
        byte[] byArray = new byte[3];
        byArray[0] = -80;
        byArray[1] = 16;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[3];
        byArray2[0] = -79;
        byArray2[1] = 16;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[3];
        byArray3[0] = -78;
        byArray3[1] = 16;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[3];
        byArray4[0] = -77;
        byArray4[1] = 16;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[3];
        byArray5[0] = -76;
        byArray5[1] = 16;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[3];
        byArray6[0] = -75;
        byArray6[1] = 16;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[3];
        byArray7[0] = -74;
        byArray7[1] = 16;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[3];
        byArray8[0] = -73;
        byArray8[1] = 16;
        byArrayArray[7] = byArray8;
        displayLineNumbers = byArrayArray;
    }

    Display() {
        AT91C_PIOA_SODR = new AT91_REG(-3024);
        AT91C_PIOA_CODR = new AT91_REG(-3020);
        spi = new SPI(-131072, 256);
        this.buf = new byte[1];
    }

    public void gotoLine(byte lineNo) {
        this.displayWrite(displayLineNumbers[lineNo], true);
    }

    private void put(byte b) {
        Display.displayWait();
        this.buf[0] = b;
        this.displayWrite(this.buf, false);
    }

    private static void displayWait() {
        while ((Display.spi.SPI_SR & 0x200) == 0) {
        }
    }

    private boolean displayWrite(byte[] pData, boolean isCmd) {
        boolean result = false;
        if ((Display.spi.SPI_SR & 0x200) > 0) {
            if (isCmd) {
                Display.AT91C_PIOA_CODR.reg = 4096;
            } else {
                Display.AT91C_PIOA_SODR.reg = 4096;
            }
            int bufferAddress = ObjectInfo.getAddress(pData);
            SPI.spiPDC.TPR = bufferAddress += 4;
            SPI.spiPDC.TCR = pData.length;
            SPI.spiPDC.PTCR = 256;
            result = true;
        }
        return result;
    }

    public void print(byte b) {
        this.put(b);
    }

    public void print(char c) {
        byte[] buf = C64Font.get(c);
        Display.displayWait();
        this.displayWrite(buf, false);
    }

    public void print(String s) {
        char[] arr = s.toCharArray();
        int i = 0;
        while (i < arr.length) {
            this.print(arr[i]);
            ++i;
        }
    }

    public void printAt(byte lineNo, String s) {
        this.gotoLine(lineNo);
        this.print(s);
    }
}

