/*
 * Decompiled with CFR 0.152.
 */
package vm;

import icecaptools.IcecapCompileMe;
import vm.InterruptHandler;

public class InterruptDispatcher {
    protected static InterruptHandler[] handlers;
    protected static int numberOfInterrupts;
    protected static boolean init;
    static final byte HVM_CLOCK = 0;

    static {
        init = false;
    }

    protected InterruptDispatcher() {
    }

    @IcecapCompileMe
    public static void registerHandler(InterruptHandler iHandler, byte n) {
        if (n <= numberOfInterrupts) {
            if (handlers[n] == null) {
                InterruptDispatcher.interrupt(n);
            }
            InterruptDispatcher.handlers[n] = iHandler;
        }
    }

    @IcecapCompileMe
    private static void interrupt(byte n) {
        handlers[n].handle();
    }

    public static void init() {
        NullHandler nh = new NullHandler();
        int i = 0;
        while (i < numberOfInterrupts) {
            InterruptDispatcher.handlers[i] = nh;
            i = (byte)(i + 1);
        }
    }

    private static class NullHandler
    implements InterruptHandler {
        private NullHandler() {
        }

        @Override
        @IcecapCompileMe
        public void handle() {
        }

        @Override
        public void register() {
        }

        @Override
        public void enable() {
        }

        @Override
        public void disable() {
        }
    }
}

