/*
 * Decompiled with CFR 0.152.
 */
package reflect;

import icecaptools.IcecapCompileMe;

public class Unboxing {
    @IcecapCompileMe
    public static void unbox(Object box) {
        if (box instanceof Long) {
            Long l = (Long)box;
            Unboxing.reportLong(l);
        } else if (box instanceof Integer) {
            Integer i = (Integer)box;
            Unboxing.reportInt(i);
        } else if (box instanceof Short) {
            Short s = (Short)box;
            Unboxing.reportShort(s);
        } else if (box instanceof Byte) {
            Byte b = (Byte)box;
            Unboxing.reportByte(b);
        } else if (box instanceof Boolean) {
            Boolean b = (Boolean)box;
            Unboxing.reportBoolean(b);
        } else if (box instanceof Character) {
            Character b = (Character)box;
            Unboxing.reportCharacter(b.charValue());
        }
    }

    @IcecapCompileMe
    public static Boolean boxBoolean(boolean b) {
        return new Boolean(b);
    }

    @IcecapCompileMe
    public static Byte boxByte(byte b) {
        return new Byte(b);
    }

    @IcecapCompileMe
    public static Short boxShort(short b) {
        return new Short(b);
    }

    @IcecapCompileMe
    public static Character boxCharacter(char b) {
        return new Character(b);
    }

    @IcecapCompileMe
    public static Integer boxInteger(int b) {
        return new Integer(b);
    }

    @IcecapCompileMe
    public static Long boxLong(long b) {
        return new Long(b);
    }

    private static native void reportLong(long var0);

    private static native void reportInt(int var0);

    private static native void reportShort(short var0);

    private static native void reportByte(byte var0);

    private static native void reportBoolean(boolean var0);

    private static native void reportCharacter(char var0);
}

