/*
 * Decompiled with CFR 0.152.
 */
package reflect;

import icecaptools.IcecapCompileMe;
import reflect.StaticRefInfo32;
import reflect.StaticRefInfo64;
import vm.Address;
import vm.Address32Bit;
import vm.Address64Bit;
import vm.Architecture;
import vm.HardwareObject;

public class StaticRefInfo {
    private static int[] offsets;
    static ReferenceArray ra;

    @IcecapCompileMe
    public static int[] getOffsets() {
        if (offsets == null) {
            OffsetsArray oa;
            switch (Architecture.architecture) {
                case 1: {
                    oa = new OffsetsArray(StaticRefInfo64.staticReferenceOffsets);
                    break;
                }
                case 2: {
                    oa = new OffsetsArray(StaticRefInfo32.staticReferenceOffsets);
                    break;
                }
                default: {
                    oa = null;
                }
            }
            int length = oa.data;
            int index = 0;
            offsets = new int[length];
            oa.advance();
            while (length > 0) {
                int n = index;
                index = (short)(n + 1);
                StaticRefInfo.offsets[n] = oa.data;
                oa.advance();
                --length;
            }
        }
        return offsets;
    }

    @IcecapCompileMe
    public static int getReference(int offset) {
        Address64Bit adr;
        if (ra == null) {
            ra = new ReferenceArray();
        }
        switch (Architecture.architecture) {
            case 1: {
                adr = new Address64Bit(StaticRefInfo64.classData);
                break;
            }
            case 2: {
                adr = new Address64Bit(StaticRefInfo32.classData);
                break;
            }
            default: {
                adr = null;
            }
        }
        ((Address)adr).add(offset);
        ra.setAddress(adr);
        return StaticRefInfo.ra.data;
    }

    private static class OffsetsArray
    extends HardwareObject {
        public int data;

        public OffsetsArray(int address) {
            super(new Address32Bit(address));
        }

        public OffsetsArray(long address) {
            super(new Address64Bit(address));
        }

        public void advance() {
            this.address.add(4);
        }
    }

    private static class ReferenceArray
    extends HardwareObject {
        public int data;

        public ReferenceArray() {
            super(new Address32Bit(0));
        }

        public void setAddress(Address adr) {
            this.address = adr;
        }
    }
}

