/*
 * Decompiled with CFR 0.152.
 */
package minicdj;

import devices.Console;
import javax.realtime.PriorityParameters;
import javax.safetycritical.Launcher;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.Safelet;
import javax.safetycritical.StorageParameters;
import javax.scj.util.Const;
import minicdj.cdx.Constants;
import minicdj.cdx.Level0Safelet;
import minicdj.utils.Utils;

public class MyApp
implements Safelet {
    public MissionSequencer getSequencer() {
        Console.println("** MyApp.getSequencer");
        return new MySequencer();
    }

    @Override
    public long immortalMemorySize() {
        return Const.IMMORTAL_MEM_SIZE;
    }

    public static void main(String[] args) {
        Console.println("\n****** mini cdj: main.begin");
        if (args.length > 0) {
            Constants.NUMBER_OF_PLANES = Integer.parseInt(args[0]);
        }
        if (args.length > 1) {
            Constants.DETECTOR_PERIOD = Integer.parseInt(args[1]);
        }
        if (args.length > 2) {
            Constants.MAX_FRAMES = Integer.parseInt(args[2]);
        }
        Utils.debugPrint("Planes: " + Constants.NUMBER_OF_PLANES);
        Utils.debugPrint("Period: " + Constants.DETECTOR_PERIOD);
        Utils.debugPrint("Frames: " + Constants.MAX_FRAMES);
        new Launcher(new MyApp(), 0);
        Console.println("   ****** mini cdj: main.end **************");
    }

    @Override
    public void initializeApplication() {
    }

    final class MySequencer
    extends MissionSequencer {
        private Level0Safelet mission;

        MySequencer() {
            super(new PriorityParameters(99), new StorageParameters(Const.PRIVATE_MEM_SIZE, null, 0L, 0L, 0L));
            Console.println("---- MySequencer.constructor: super finished");
            this.mission = new Level0Safelet();
            this.mission.setup();
            Console.println("MySequencer.constructor: MyMission created");
        }

        public Mission getNextMission() {
            if (this.mission.terminationPending()) {
                Console.println("\n ** MySequencer.getNextMission: null \n    missionTerminate: " + this.mission.terminationPending());
                this.mission.teardown();
                return null;
            }
            Console.println("\nMySequencer.getNextMission:" + this.mission + "\n    missionTerminate: " + this.mission.terminationPending());
            return this.mission;
        }
    }
}

