/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.MemoryArea;
import javax.realtime.NoHeapRealtimeThread;
import javax.realtime.PriorityParameters;
import javax.realtime.ReleaseParameters;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.ManagedSchedulableSet;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionMemory;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.PrivateMemory;
import javax.safetycritical.ScjProcess;
import javax.safetycritical.StorageParameters;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.Phase;
import javax.safetycritical.annotate.SCJAllowed;
import javax.safetycritical.annotate.SCJRestricted;
import vm.ClockInterruptHandler;

public class ManagedThread
extends NoHeapRealtimeThread
implements ManagedSchedulable {
    StorageParameters storage;
    ScjProcess process;
    Mission mission = null;
    private PriorityScheduler sch;
    protected boolean isAutoStart = true;
    ManagedMemory privateMemory;
    MemoryArea currentMemory;
    MemoryArea topMemory;

    public ManagedThread(PriorityParameters priority, StorageParameters storage, String name) {
        this(priority, storage, null, name);
    }

    public ManagedThread(PriorityParameters priority, StorageParameters storage, Runnable logic, String name) {
        super(priority, logic, name);
        if (storage == null) {
            throw new IllegalArgumentException("storage is null");
        }
        this.storage = storage;
        this.mission = Mission.getCurrentMission();
        int backingStoreOfThisMemory = this.mission == null ? MemoryArea.getRemainingMemorySize() : (int)this.storage.totalBackingStore;
        MissionMemory backingStoreProvider = this.mission == null ? null : this.mission.missionSeq.missionMemory;
        this.privateMemory = new PrivateMemory((int)this.storage.getMaxMemoryArea(), backingStoreOfThisMemory, backingStoreProvider);
        this.currentMemory = this.privateMemory;
        this.topMemory = this.privateMemory;
    }

    protected void start() {
        if (this.process == null) {
            return;
        }
        if (!this.isAutoStart && this.process.getState() == 3) {
            ClockInterruptHandler.instance.disable();
            this.process.setState(1);
            this.sch.insertReleaseQueue(this.process);
            ClockInterruptHandler.instance.enable();
        }
    }

    public boolean isAutoStart() {
        return this.isAutoStart;
    }

    @Override
    @SCJAllowed(value=Level.INFRASTRUCTURE)
    @SCJRestricted(value=Phase.INITIALIZE)
    public final void register() {
        ManagedSchedulableSet hs = this.mission.MSSetForMission;
        hs.addMS(this);
        this.sch = PriorityScheduler.instance();
    }

    @Override
    @SCJAllowed(value=Level.SUPPORT)
    @SCJRestricted(value=Phase.CLEANUP)
    public void cleanUp() {
        this.privateMemory.removeArea();
    }

    @Override
    public StorageParameters getStorageParameter() {
        return this.storage;
    }

    @Override
    public ManagedMemory getManagedMemory() {
        return this.privateMemory;
    }

    @Override
    public ScjProcess getScjProcess() {
        return this.process;
    }

    @Override
    public void setScjProcess(ScjProcess process) {
        this.process = process;
    }

    @Override
    public ReleaseParameters getReleaseParameter() {
        return null;
    }

    @Override
    public Mission getMission() {
        return this.mission;
    }

    @Override
    public void setMission(Mission m) {
        this.mission = m;
    }

    @Override
    public void signalTermination() {
    }

    @Override
    public void setCurrentMemory(MemoryArea current) {
        this.currentMemory = current;
    }

    @Override
    public MemoryArea getCurrentMemory() {
        return this.currentMemory;
    }

    @Override
    public void setTopMemory(MemoryArea topMemory) {
        this.topMemory = topMemory;
    }

    @Override
    public MemoryArea getTopMemory() {
        return this.topMemory;
    }
}

