/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.Monitor;
import javax.realtime.PriorityScheduler;
import javax.realtime.RtProcess;
import vm.ClockInterruptHandler;
import vm.Process;
import vm.Scheduler;

final class PrioritySchedulerImpl
implements Scheduler {
    PriorityScheduler sch;

    protected PrioritySchedulerImpl(PriorityScheduler sch) {
        this.sch = sch;
    }

    @Override
    public Process getNextProcess() {
        RtProcess scjProcess = this.sch.move();
        if (scjProcess != null) {
            return scjProcess.process;
        }
        this.sch.stop(this.sch.current.process);
        return null;
    }

    protected void waitForMS(Monitor monitor) {
        ClockInterruptHandler.instance.disable();
        monitor.unlockWithOutEnable();
        this.sch.pFrame.waitQueue.addProcess(monitor, this.sch.current);
        RtProcess next = this.sch.pFrame.queue.extractMin();
        next.state = 2;
        this.sch.current = next;
        ClockInterruptHandler.instance.enable();
        ClockInterruptHandler.instance.handle();
    }

    protected void notifyForMS(Monitor monitor) {
        RtProcess process = this.sch.pFrame.waitQueue.getNextProcess(monitor);
        if (process != null) {
            this.sch.pFrame.lockQueue.addProcess(monitor, process);
        }
    }

    @Override
    public void wait(Object target) {
        Monitor monitor = Monitor.getMonitor(target);
        monitor.unlockWithOutEnable();
        this.sch.pFrame.waitQueue.addProcess(monitor, this.sch.current);
        RtProcess next = this.sch.pFrame.queue.extractMin();
        next.state = 2;
        this.sch.current = next;
    }

    @Override
    public void notify(Object target) {
        Monitor monitor = Monitor.getMonitor(target);
        RtProcess process = this.sch.pFrame.waitQueue.getNextProcess(monitor);
        if (process != null) {
            if (process.next_temp != null) {
                this.sch.pFrame.queue.remove(process);
                process.next.set(process.next_temp);
                process.next_temp = null;
                process.isNotified = true;
            }
            this.sch.pFrame.lockQueue.addProcess(monitor, process);
        }
    }

    @Override
    public void notifyAll(Object target) {
        Monitor monitor = Monitor.getMonitor(target);
        RtProcess process = this.sch.pFrame.waitQueue.getNextProcess(monitor);
        while (process != null) {
            if (process != null && process.next_temp != null) {
                this.sch.pFrame.queue.remove(process);
                process.next.set(process.next_temp);
                process.next_temp = null;
                process.isNotified = true;
            }
            this.sch.pFrame.lockQueue.addProcess(monitor, process);
            process = this.sch.pFrame.waitQueue.getNextProcess(monitor);
        }
    }
}

