package uk.ac.york.tokeneer.realworld;


/**
 * Dummy class representing the real world. Used for simulation purposes
 * 
 * @author Jon Co
 * 
 */
public class DummyRealWorld {

	private static final DummyRealWorld instance = new DummyRealWorld();

	// Door System
	private volatile AlarmState alarmState = AlarmState.OFF;
	private volatile DoorState doorState = DoorState.CLOSED;
	private volatile LatchState latchState = LatchState.LOCKED;

	// Identification Peripherals
	private volatile String token;
	private volatile String finger;

	private DummyRealWorld() {
		;
	}

	/**
	 * @return Instance of the Real World
	 */
	public static DummyRealWorld getInstance() {
		return instance;
	}

	public synchronized AlarmState getAlarm() {
		return this.alarmState;
	}

	public synchronized void setAlarm(AlarmState state) {
		this.alarmState = state;
	}

	public synchronized DoorState getDoor() {
		return this.doorState;
	}

	public synchronized void setDoor(DoorState state) {
		this.doorState = state;
	}

	public synchronized LatchState getLatch() {
		return this.latchState;
	}

	public synchronized void setLatch(LatchState state) {
		this.latchState = state;
	}

	/**
	 * Get the current token in the token reader.
	 * 
	 * @param token
	 *            The contents of the currently in the token reader.If nothing
	 *            is present return {@code null}.
	 */
	public synchronized String getToken() {
		return this.token;
	}

	/**
	 * Set the current token in the token reader.
	 * 
	 * @param token
	 *            Value for the token reader to return. A {@code null} token is
	 *            equivalent to no token being present in the reader.
	 */
	public synchronized void setToken(String token) {
		this.token = token;
	}

	public synchronized String getFinger() {
		return finger;
	}

	public synchronized void setFinger(String finger) {
		this.finger = finger;
	}

}
