package uk.ac.york.tokeneer.realworld;

/**
 * Dummy implementation of {@link Door} for simulation purposes.
 * 
 * @author Jon Co
 * 
 */
public class DummyDoor implements Door {
	
	// Internal representation of Door
	private volatile DoorState state = DoorState.UNKNOWN;

	/**
	 * Default Constructor
	 */
	public DummyDoor() {
		;
	}

	@Override
	public synchronized DoorState getState() {
		return this.state;
	}

	@Override
	public synchronized DoorState pollState() {
		this.state = DummyRealWorld.getInstance().getDoor();
		return this.state;
	}

}
