package uk.ac.york.tokeneer;

import javax.realtime.PriorityParameters;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageConfigurationParameters;

/**
 * Main {@link MissionSequencer} implementation for SCJ Tokeneer. Runs the only
 * available mission in this application.
 * 
 * @author Jon Co
 * 
 */
public class TokeneerSequencer extends MissionSequencer {

	/**
	 * Default Constructor
	 */
	public TokeneerSequencer() {
		// @formatter:off
		super(
				new PriorityParameters(PriorityScheduler.instance().getMaxPriority()), 
				new StorageConfigurationParameters(1048576, 4096, 4096));
		// @formatter:on
	}

	@Override
	protected Mission getNextMission() {
		final ConfigData config = new ConfigData();
		return new TokeneerMission(config);
	}

}
