package uk.ac.york.tokeneer;

import java.util.concurrent.atomic.AtomicReference;

import javax.realtime.AperiodicParameters;
import javax.realtime.HighResolutionTime;
import javax.realtime.PriorityParameters;
import javax.safetycritical.OneShotEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageConfigurationParameters;

/**
 * {@link OneShotEventHandler} for specifying the window in which a Fingerprint
 * can be read by the system during the user entry operation.
 * 
 * @author Jon Co
 * 
 */
public class FingerTimeout extends AbstractTimeout {

	private static final String TAG = "FingerTimeout";

	private final AtomicReference<UserEntryState> state;

	// @formatter:off
	public FingerTimeout(
			final HighResolutionTime timeout,
			final AtomicReference<UserEntryState> userEntryState) {
		super(timeout,
				new PriorityParameters(PriorityScheduler.instance().getMaxPriority()), 
				new AperiodicParameters(),
				new StorageConfigurationParameters(4096, 4096, 4096), 
				4096);
		this.state = userEntryState;
	}
	// @formatter:on

	@Override
	public void handleEvent() {
		Log.d(TAG, "Finger Timeout Expired");
		final boolean hasFailedEntry = this.state.compareAndSet(
				UserEntryState.WAITING_FINGER,
				UserEntryState.WAITING_TOKEN_REMOVAL_FAILURE);
		if (hasFailedEntry) {
			Log.i(TAG, "Failed to give finger in time");
		}
	}

	public synchronized void startTimeout() {
		Log.d(TAG, "Finger Timeout Started");
		super.startTimeout();
	}

	@Override
	public synchronized boolean deschedule() {
		Log.d(TAG, "Finger Timeout Stopped");
		return super.deschedule();
	}

}
