package uk.ac.york.tokeneer.realworld;

/**
 * Interface describing a controller for the real world Token Reader.
 * 
 * @author Jon Co
 * 
 */
public interface TokenReader {

	/**
	 * Retrieve the last Token read by this controller.
	 * 
	 * @return The current Token stored. If no token has been read or has been
	 *         cleared then {@code null} is returned.
	 */
	public String getToken();

	/**
	 * Poll the real world token reader and return the current contents.
	 * 
	 * @return The token read from the reader. If no token has been read then
	 *         {@code null} is returned.
	 */
	public String pollToken();

	/**
	 * Clear the last Token read by this controller.
	 */
	public void clearToken();

}
