package uk.ac.york.tokeneer.realworld;

/**
 * Interface describing a controller for the real world Door.
 * 
 * @author Jon Co
 * 
 */
public interface Door {

	/**
	 * Get the current state of the door as stored in this controller. If the
	 * current real world state is needed use {@link #pollState()}.
	 * 
	 * @return The current state of the door as stored in this controller.
	 */
	public DoorState getState();

	/**
	 * Get the current state of the door in the real world and update this
	 * controllers internal representation.
	 * 
	 * @return The current state of the door in the real world.
	 */
	public DoorState pollState();
}
