package uk.ac.york.tokeneer.realworld;

/**
 * Interface describing a controller for the real world Alarm.
 * 
 * @author Jon Co
 * 
 */
public interface Alarm {

	/**
	 * Get the current state of the alarm as stored in this controller. If the
	 * current real world state is needed use {@link #pollState()}.
	 * 
	 * @return The current state of the alarm as stored in this controller.
	 */
	public AlarmState getState();

	/**
	 * Get the current state of the alarm in the real world and update this
	 * controllers internal representation.
	 * 
	 * @return The current state of the alarm in the real world.
	 */
	public AlarmState pollState();

	/**
	 * Activate the alarm i.e. change the real world state to
	 * {@link AlarmState#ON}.
	 */
	public void activate();

	/**
	 * Deactivate the alarm i.e. change the real world state to
	 * {@link AlarmState#OFF}.
	 */
	public void deactivate();
}
