package uk.ac.york.tokeneer;

import java.util.concurrent.atomic.AtomicReference;

import javax.realtime.AperiodicParameters;
import javax.realtime.PriorityParameters;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageConfigurationParameters;

import uk.ac.york.tokeneer.realworld.TokenReader;

/**
 * Handler for processing User Token inputs.
 * 
 * @author Jon Co
 * 
 */
public class TokenInuptHandler extends AperiodicEventHandler {

	private static final String TAG = "TokenInput";

	private final TokenReader token;
	private final FingerTimeout fingerTimeout;

	private final AtomicReference<UserEntryState> state;

	// @formatter:off
	public TokenInuptHandler(
			final AtomicReference<UserEntryState> state,
			final TokenReader token,
			final FingerTimeout fingerTimeoutHandler) {
		super(
				new PriorityParameters(PriorityScheduler.instance().getNormPriority()), 
				new AperiodicParameters(),
				new StorageConfigurationParameters(4096, 4096, 4096), 
				4096);
		// @formatter:on

		this.state = state;
		this.token = token;
		this.fingerTimeout = fingerTimeoutHandler;
	}

	@Override
	public void handleEvent() {
		Log.i(TAG, "Received token input");
		if (this.state.get() == UserEntryState.IDLE) {
			final String token = this.token.pollToken();
			if (this.isTokenValid(token)) {
				this.state.set(UserEntryState.WAITING_FINGER);
				this.fingerTimeout.startTimeout();
				Log.i(TAG, "Token valid");
			} else {
				this.state.set(UserEntryState.WAITING_TOKEN_REMOVAL_FAILURE);
				Log.i(TAG, "Token invalid");
			}
		}
	}

	/**
	 * Returns {@code true} if the token is valid, {@code false} otherwise.
	 * 
	 * XXX: This is a dummy implementation. Returns true if given string is
	 * "True" case insensitive.
	 * 
	 * TODO: Move into a separate validator class
	 * 
	 * @param token
	 * @return
	 */
	private boolean isTokenValid(String token) {
		return Boolean.valueOf(token);
	}
}
