package uk.ac.york.tokeneer;

import javax.realtime.Clock;

/**
 * Utility for outputting messages to console with current timestamp in millis.
 * Used for simulating logging purposes.
 * 
 * @author Jon Co
 * 
 */
public class Log {

	private static final boolean DEBUG = true;

	private Log() {
		;
	}

	/**
	 * Log Info
	 * 
	 * @param tag
	 * @param message
	 */
	public static void i(String tag, String message) {
		System.out.println("[I]#"
				+ Clock.getRealtimeClock().getTime().getMilliseconds() + "#"
				+ tag + "#" + message);
	}

	public static void d(String tag, String message) {
		if (DEBUG) {
			System.out.println("[D]#"
					+ Clock.getRealtimeClock().getTime().getMilliseconds()
					+ "#" + tag + "#" + message);
		}
	}
	
	public static void testBegin(String testName) {
		System.out.println("=====\n BEGIN TEST: " + testName + "\n=====");
	}
	
	public static void testEnd(String testName) {
		System.out.println("=====\n END TEST: " + testName + "\n=====");
	}
}
