package uk.ac.york.tokeneer;

import javax.realtime.AperiodicParameters;
import javax.realtime.HighResolutionTime;
import javax.realtime.PriorityParameters;
import javax.safetycritical.OneShotEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageConfigurationParameters;

import uk.ac.york.tokeneer.realworld.Latch;

/**
 * {@link OneShotEventHandler} for locking the Latch after the timeout has been
 * exceeded.
 * 
 * @author Jon Co
 * 
 */
public class LatchTimeout extends AbstractTimeout {

	private static final String TAG = "LatchTimeout";

	private final Latch latch;
	
	/**
	 * Default Constructor
	 * 
	 * @param timeout
	 *            Duration before the Latch should be relocked.
	 * @param controller
	 *            Interface to real world controls. Used to activate the Latch.
	 * @param state
	 *            The internal state of the system.
	 */
	// @formatter:off
	public LatchTimeout(final HighResolutionTime timeout,
			final Latch latch) {
		super(timeout,
				new PriorityParameters(PriorityScheduler.instance().getMaxPriority()), 
				new AperiodicParameters(),
				new StorageConfigurationParameters(4096, 4096, 4096), 
				4096);
		this.latch = latch;
	}
	// @formatter:on

	@Override
	public void handleEvent() {
		this.latch.lock();
		Log.d(TAG, "Latch Timeout Expired");
	}

	/**
	 * Start the timeout for the latch.
	 */
	public synchronized void startTimeout() {
		Log.d(TAG, "Latch Timeout Started");
		super.startTimeout();
	}

	@Override
	public synchronized boolean deschedule() {
		Log.d(TAG, "Latch Timeout Stopped");
		return super.deschedule();
	}
}
