package uk.ac.york.tokeneer;

import java.util.concurrent.atomic.AtomicReference;

import javax.realtime.AperiodicParameters;
import javax.realtime.PriorityParameters;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageConfigurationParameters;

import uk.ac.york.tokeneer.realworld.FingerReader;

/**
 * Handler for processing Finger inputs.
 * 
 * @author Jon Co
 * 
 */
public class FingerInputHandler extends AperiodicEventHandler {

	private static final String TAG = "FingerInput";

	private final TokenRemovalTimeout tokenRemovalTimeout;
	private final FingerReader fingerReader;

	private final AtomicReference<UserEntryState> state;

	// @formatter:off
	public FingerInputHandler(
			final AtomicReference<UserEntryState> state,
			final FingerReader fingerReader,
			final TokenRemovalTimeout tokenRemovalTimeout) {
		super(
				new PriorityParameters(PriorityScheduler.instance().getNormPriority()), 
				new AperiodicParameters(), 
				new StorageConfigurationParameters(4096, 4096, 4096), 
				4096);
		// @formatter:on
		this.state = state;
		this.fingerReader = fingerReader;
		this.tokenRemovalTimeout = tokenRemovalTimeout;
	}
	

	@Override
	public void handleEvent() {
		Log.i(TAG, "Received Finger Input");

		// Process the fingerprint only if in the correct step of entry
		if (this.state.get() == UserEntryState.WAITING_FINGER) {
			final String finger = this.fingerReader.pollFinger();
			if (this.isFingerValid(finger)) {
				this.state.set(UserEntryState.WAITING_TOKEN_REMOVAL_SUCCESS);
				this.tokenRemovalTimeout.startTimeout();
				Log.i(TAG, "Fingerprint valid");
			} else {
				this.state.set(UserEntryState.WAITING_TOKEN_REMOVAL_FAILURE);
				Log.i(TAG, "Fingerprint invalid");
			}
		}
	}

	private boolean isFingerValid(String finger) {
		return Boolean.valueOf(finger);
	}

}
