package uk.ac.york.tokeneer;

import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.AperiodicEvent;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageConfigurationParameters;

import uk.ac.york.tokeneer.realworld.DoorState;
import uk.ac.york.tokeneer.realworld.DummyRealWorld;
import uk.ac.york.tokeneer.realworld.LatchState;

/**
 * Handler to provide dummy input.
 * 
 * @author Jon Co
 * 
 */
public class DummyInputHandler extends PeriodicEventHandler {

	private final AperiodicEvent tokenRemovalEvent;
	private final AperiodicEvent tokenInputEvent;
	private final AperiodicEvent fingerInputEvent;

	private int stepCounter = 0;
	private int testCounter = 6;

	// @formatter:off
	public DummyInputHandler(
			final AperiodicEvent tokenRemovalEvent,
			final AperiodicEvent tokenInputEvent, 
			final AperiodicEvent fingerInputEvent) {
		super(
				new PriorityParameters(PriorityScheduler.instance().getMaxPriority()), 
				new PeriodicParameters(new RelativeTime(1000, 0)), 
				new StorageConfigurationParameters(4096, 4096, 4096), 
				4096);
		this.tokenRemovalEvent = tokenRemovalEvent;
		this.tokenInputEvent = tokenInputEvent;
		this.fingerInputEvent = fingerInputEvent;
	}
	// @formatter:on

	@Override
	public synchronized void handleEvent() {
		this.stepCounter++;

		switch (this.testCounter) {
		case 0:
			this.testValidEntry();
			break;
		case 1:
			this.testEntryBadToken();
			break;
		case 2:
			this.testEntryBadFinger();
			break;
		case 3:
			this.testEntryNoFinger();
			break;
		case 4:
			this.testEntryNoTokenRemoval();
			break;
		case 5:
			this.testLatchTimeout();
			break;
		case 6:
			this.testAlarmTimeout();
			break;
		default:
			// All tests finished, exit. Should call mission terminate
			System.exit(0);
		}
	}

	private void testValidEntry() {
		String name = "SUCCESSFUL USER ENTRY";
		switch (this.stepCounter) {
		case 2:
			Log.testBegin(name);
			this.insertGoodToken();
			break;
		case 4:
			this.insertGoodFinger();
			break;
		case 6:
			this.removeToken();
			break;
		case 16:
			this.testReset();
			Log.testEnd(name);
			break;
		default:
			break;
		}
	}

	private void testEntryBadToken() {
		String name = "FAILED USER ENTRY - INVALID TOKEN";
		switch (this.stepCounter) {
		case 2:
			Log.testBegin(name);
			this.insertBadToken();
			break;
		case 6:
			this.removeToken();
			break;
		case 10:
			this.testReset();
			Log.testEnd(name);
			break;
		default:
			break;
		}
	}

	private void testEntryBadFinger() {
		String name = "FAILED USER ENTRY - INVALID FINGERPRINT";
		switch (this.stepCounter) {
		case 2:
			Log.testBegin(name);
			this.insertGoodToken();
			break;
		case 4:
			this.insertBadFinger();
			break;
		case 6:
			this.removeToken();
			break;
		case 10:
			this.testReset();
			Log.testEnd(name);
			break;
		default:
			break;
		}
	}

	private void testEntryNoFinger() {
		String name = "FAILED USER ENTRY - FINGERPRINT TIMEOUT EXCEEDED";
		switch (this.stepCounter) {
		case 2:
			Log.testBegin(name);
			this.insertGoodToken();
			break;
		case 8:
			this.removeToken();
			break;
		case 10:
			this.testReset();
			Log.testEnd(name);
			break;
		default:
			break;
		}
	}

	private void testEntryNoTokenRemoval() {
		String name = "FAILED USER ENTRY - TOKEN REMOVAL TIMEOUT EXCEEDED";
		switch (this.stepCounter) {
		case 2:
			Log.testBegin(name);
			this.insertGoodToken();
			break;
		case 4:
			this.insertGoodFinger();
			break;
		case 10:
			this.removeToken();
			break;
		case 12:
			this.testReset();
			Log.testEnd(name);
			break;
		default:
			break;
		}
	}

	private void testLatchTimeout() {
		String name = "PHYSICAL SECURITY - LATCH IS RELOCKED";
		switch (this.stepCounter) {
		case 2:
			Log.testBegin(name);
			this.insertGoodToken();
			break;
		case 4:
			this.insertGoodFinger();
			break;
		case 6:
			this.removeToken();
			break;
		case 14:
			this.closeDoor();
			this.testReset();
			Log.testEnd(name);
			break;
		default:
			break;
		}
	}

	private void testAlarmTimeout() {
		String name = "PHYSICAL SECURITY - ALARM IS ACTIVATED";
		switch (this.stepCounter) {
		case 2:
			Log.testBegin(name);
			this.insertGoodToken();
			break;
		case 4:
			this.insertGoodFinger();
			break;
		case 6:
			this.removeToken();
			break;
		case 8:
			this.openDoor();
			break;
		case 20:
			this.closeDoor();
			this.testReset();
			Log.testEnd(name);
			break;
		default:
			break;
		}
	}

	private void openDoor() {
		if (DummyRealWorld.getInstance().getLatch() == LatchState.UNLOCKED) {
			DummyRealWorld.getInstance().setDoor(DoorState.OPEN);
		}
	}

	private void closeDoor() {
		DummyRealWorld.getInstance().setDoor(DoorState.CLOSED);
	}

	private void insertGoodToken() {
		DummyRealWorld.getInstance().setToken("true");
		this.tokenInputEvent.fire();
	}

	private void insertBadToken() {
		DummyRealWorld.getInstance().setToken("false");
		this.tokenInputEvent.fire();
	}

	private void removeToken() {
		DummyRealWorld.getInstance().setToken(null);
		this.tokenRemovalEvent.fire();
	}

	private void insertGoodFinger() {
		DummyRealWorld.getInstance().setFinger("true");
		this.fingerInputEvent.fire();
	}

	private void insertBadFinger() {
		DummyRealWorld.getInstance().setFinger("false");
		this.fingerInputEvent.fire();
	}

	private void removeFinger() {
		DummyRealWorld.getInstance().setFinger(null);
	}

	private void testReset() {
		this.stepCounter = 0;
		this.testCounter++;
	}
}
