package uk.ac.york.tokeneer;

/**
 * Wrapper for Configuration Data used by Tokeneer. All times should be 
 * specified in milliseconds.
 * 
 * WARNING NONE OF THE METHODS IN THIS CLASS ARE THREADSAFE
 * 
 * @author Jon Co
 */
public class ConfigData {
	
	private volatile long updateInterval = 1000;

	private volatile long latchTimeout = 5000;
	private volatile long alarmTimeout = latchTimeout + 5000;
	
	private volatile long tokenRemovalTimeout = 5000;
	private volatile long fingerTimeout = 5000;

	/**
	 * Default Constructor
	 */
	public ConfigData() {
		;
	}

	public synchronized long getUpdateInterval() {
		return updateInterval;
	}

	public synchronized void setUpdateInterval(long updateInterval) {
		this.updateInterval = updateInterval;
	}

	public synchronized long getLatchTimeout() {
		return latchTimeout;
	}

	public synchronized void setLatchTimeout(long latchTimeout) {
		this.latchTimeout = latchTimeout;
	}

	public synchronized long getAlarmTimeout() {
		return alarmTimeout;
	}

	public synchronized void setAlarmTimeout(long alarmTimeout) {
		this.alarmTimeout = alarmTimeout;
	}

	public synchronized long getTokenRemovalTimout() {
		return tokenRemovalTimeout;
	}

	public synchronized void setTokenRemovalTimeout(long tokenRemovalTimeout) {
		this.tokenRemovalTimeout = tokenRemovalTimeout;
	}

	public synchronized long getFingerTimeout() {
		return fingerTimeout;
	}

	public synchronized void setFingerTimeout(long fingerTimeout) {
		this.fingerTimeout = fingerTimeout;
	}
}
