/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.stackanalyser;

import icecaptools.BNode;
import icecaptools.FieldAccessBNode;
import icecaptools.JavaArrayClass;
import icecaptools.LDCBNode;
import icecaptools.MethodEntryPoints;
import icecaptools.MethodOrFieldDesc;
import icecaptools.StaticFieldAccessBNode;
import icecaptools.compiler.LDCConstant;
import icecaptools.stackanalyser.ProducerConsumerCellInfo;
import java.util.ArrayList;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;

public class Util {
    public static ArrayList<String> getCellType(MethodEntryPoints method, ProducerConsumerCellInfo cell) throws Exception {
        ArrayList<String> types = new ArrayList<String>();
        Util.collectCellTypes(types, method, cell);
        return types;
    }

    private static void collectCellTypes(ArrayList<String> types, MethodEntryPoints method, ProducerConsumerCellInfo cell) throws Exception {
        ArrayList<BNode> producers = cell.getProducers();
        for (BNode bNode : producers) {
            Util.getProducerType(types, bNode, method, bNode.getOriginalAddress());
        }
    }

    private static void getProducerType(ArrayList<String> types, BNode bNode, MethodEntryPoints method, int pc) throws Exception {
        switch (bNode.getOpCode()) {
            case -76: {
                FieldAccessBNode fieldNode = (FieldAccessBNode)bNode;
                String signature = fieldNode.getSignature();
                String typeName = JavaArrayClass.getReferredType(signature).replace("/", ".");
                types.add(typeName);
                break;
            }
            case -78: {
                StaticFieldAccessBNode fieldNode = (StaticFieldAccessBNode)bNode;
                String signature = fieldNode.getSignature();
                String typeName = JavaArrayClass.getReferredType(signature).replace("/", ".");
                types.add(typeName);
                break;
            }
            case 89: {
                ProducerConsumerCellInfo cell = bNode.getAinfo().entryStack.peek();
                Util.collectCellTypes(types, method, cell);
                break;
            }
            case 42: {
                if (!method.getMethod().isStatic()) {
                    types.add(method.getClazz().getClassName());
                    break;
                }
            }
            case 43: 
            case 44: 
            case 45: {
                int index;
                LocalVariable var;
                LocalVariableTable localVariableTable = method.getMethod().getLocalVariableTable();
                if (localVariableTable == null || (var = localVariableTable.getLocalVariable(index = bNode.getOpCode() - 42, pc)) == null) break;
                var.getSignature();
                break;
            }
            case 25: {
                byte index;
                LocalVariable var;
                LocalVariableTable localVariableTable = method.getMethod().getLocalVariableTable();
                if (localVariableTable == null || (var = localVariableTable.getLocalVariable((int)(index = bNode.getRawBytes()[1]), pc)) == null) break;
                var.getSignature();
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                LDCBNode ldc = (LDCBNode)bNode;
                LDCConstant constant = ldc.getLDCConstant();
                switch (constant.getType()) {
                    case 1: {
                        types.add("java.lang.String");
                        break;
                    }
                    case 6: {
                        types.add("java.lang.Class");
                    }
                }
                break;
            }
            default: {
                throw new Exception("Unsupported object type for locking");
            }
        }
    }

    public static MethodOrFieldDesc getMethodOrFieldDesc(JavaClass clazz, Method method) {
        return new MethodOrFieldDesc(clazz.getClassName(), method.getName(), method.getSignature());
    }
}

