/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.stackanalyser;

import icecaptools.stackanalyser.UnknownType;

public class RefType
extends UnknownType {
    public int identicleWith = -1;
    protected RefState state = RefState.UNKNOWN;

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RefType) {
            RefType other = (RefType)obj;
            if (this.state == other.state) {
                return this.identicleWith == other.identicleWith;
            }
            return false;
        }
        return false;
    }

    @Override
    public String print() {
        return "ref:" + this.state.toString();
    }

    public RefState getState() {
        return this.state;
    }

    public void setState(RefState state) {
        this.state = state;
    }

    @Override
    public UnknownType copy() {
        RefType copy = new RefType();
        copy.state = this.state;
        copy.identicleWith = this.identicleWith;
        return copy;
    }

    public void merge(RefType other) {
        if (this.state != other.state) {
            this.state = RefState.UNKNOWN;
        }
        if (this.identicleWith != other.identicleWith) {
            this.identicleWith = -1;
        }
    }

    public static enum RefState {
        NONNULL,
        NULL,
        UNKNOWN;

    }
}

