/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.stackanalyser;

import icecaptools.BNode;
import java.util.ArrayList;
import java.util.Iterator;

public class ProducerConsumerCellInfo {
    private ArrayList<BNode> producers = new ArrayList();
    private BNode stackcellConsumer = null;

    public boolean addProducer(BNode producer) throws Exception {
        if (producer != null && !this.producers.contains(producer)) {
            this.producers.add(producer);
            return true;
        }
        return false;
    }

    public ArrayList<BNode> getProducers() {
        return this.producers;
    }

    public void addConsumer(BNode consumer) throws Exception {
        if (consumer != this.stackcellConsumer) {
            if (this.stackcellConsumer == null) {
                this.stackcellConsumer = consumer;
            } else if (consumer != null && consumer.getOpCode() != 87) {
                throw new Exception("Unexpected stack usage");
            }
        }
    }

    public BNode getConsumer() {
        return this.stackcellConsumer;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.producers.size());
        buffer.append(", ");
        Iterator<BNode> producerIterator = this.producers.iterator();
        while (producerIterator.hasNext()) {
            buffer.append(producerIterator.next().toString());
            if (!producerIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

